/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class CustomizedThreadFactory
implements ThreadFactory {
    private static final AtomicLong POOL_NUM = new AtomicLong(1L);
    private final AtomicLong threadNum = new AtomicLong(1L);
    private final String threadName;
    private final boolean daemon;

    public CustomizedThreadFactory() {
        this("pool-" + POOL_NUM.getAndIncrement(), false);
    }

    public CustomizedThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, false);
    }

    public CustomizedThreadFactory(String threadNamePrefix, boolean daemon) {
        this.threadName = threadNamePrefix + "-thread-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread runThread = new Thread(r);
        runThread.setDaemon(this.daemon);
        runThread.setName(this.threadName + this.threadNum.getAndIncrement());
        return runThread;
    }
}

