/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TimelineUtils {
    private static final Logger LOG = LogManager.getLogger(TimelineUtils.class);

    public static List<String> getWrittenPartitions(HoodieTimeline timeline) {
        HoodieTimeline timelineToSync = timeline.getWriteTimeline();
        return TimelineUtils.getAffectedPartitions(timelineToSync);
    }

    public static List<String> getDroppedPartitions(HoodieTimeline timeline) {
        HoodieTimeline replaceCommitTimeline = timeline.getWriteTimeline().filterCompletedInstants().getCompletedReplaceTimeline();
        return replaceCommitTimeline.getInstants().flatMap(instant -> {
            try {
                HoodieReplaceCommitMetadata commitMetadata = HoodieReplaceCommitMetadata.fromBytes(replaceCommitTimeline.getInstantDetails((HoodieInstant)instant).get(), HoodieReplaceCommitMetadata.class);
                if (WriteOperationType.DELETE_PARTITION.equals((Object)commitMetadata.getOperationType())) {
                    Map<String, List<String>> partitionToReplaceFileIds = commitMetadata.getPartitionToReplaceFileIds();
                    return partitionToReplaceFileIds.keySet().stream();
                }
                return Stream.empty();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to get partitions modified at " + instant, e);
            }
        }).distinct().filter(partition -> !partition.isEmpty()).collect(Collectors.toList());
    }

    public static List<String> getAffectedPartitions(HoodieTimeline timeline) {
        return timeline.filterCompletedInstants().getInstants().flatMap(s -> {
            switch (s.getAction()) {
                case "commit": 
                case "deltacommit": {
                    try {
                        HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)s).get(), HoodieCommitMetadata.class);
                        return commitMetadata.getPartitionToWriteStats().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions written at " + s, e);
                    }
                }
                case "replacecommit": {
                    try {
                        HoodieReplaceCommitMetadata commitMetadata = HoodieReplaceCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)s).get(), HoodieReplaceCommitMetadata.class);
                        HashSet<String> partitions = new HashSet<String>();
                        partitions.addAll(commitMetadata.getPartitionToReplaceFileIds().keySet());
                        partitions.addAll(commitMetadata.getPartitionToWriteStats().keySet());
                        return partitions.stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions modified at " + s, e);
                    }
                }
                case "clean": {
                    try {
                        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(timeline.getInstantDetails((HoodieInstant)s).get());
                        return cleanMetadata.getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions cleaned at " + s, e);
                    }
                }
                case "rollback": {
                    try {
                        return TimelineMetadataUtils.deserializeHoodieRollbackMetadata(timeline.getInstantDetails((HoodieInstant)s).get()).getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions rolledback at " + s, e);
                    }
                }
                case "restore": {
                    try {
                        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.deserializeAvroMetadata(timeline.getInstantDetails((HoodieInstant)s).get(), HoodieRestoreMetadata.class);
                        return restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).flatMap(rollbackMetadata -> rollbackMetadata.getPartitionMetadata().keySet().stream());
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions restored at " + s, e);
                    }
                }
                case "savepoint": {
                    try {
                        return TimelineMetadataUtils.deserializeHoodieSavepointMetadata(timeline.getInstantDetails((HoodieInstant)s).get()).getPartitionMetadata().keySet().stream();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get partitions savepoint at " + s, e);
                    }
                }
                case "compaction": {
                    return Stream.empty();
                }
            }
            throw new HoodieIOException("unknown action in timeline " + s.getAction());
        }).distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static Option<String> getExtraMetadataFromLatest(HoodieTableMetaClient metaClient, String extraMetadataKey) {
        return metaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().filter(instant -> !TimelineUtils.isClusteringCommit(metaClient, instant)).findFirst().map(instant -> TimelineUtils.getMetadataValue(metaClient, extraMetadataKey, instant)).orElse(Option.empty());
    }

    public static Option<String> getExtraMetadataFromLatestIncludeClustering(HoodieTableMetaClient metaClient, String extraMetadataKey) {
        return metaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().findFirst().map(instant -> TimelineUtils.getMetadataValue(metaClient, extraMetadataKey, instant)).orElse(Option.empty());
    }

    public static Map<String, Option<String>> getAllExtraMetadataForKey(HoodieTableMetaClient metaClient, String extraMetadataKey) {
        return metaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().collect(Collectors.toMap(HoodieInstant::getTimestamp, instant -> TimelineUtils.getMetadataValue(metaClient, extraMetadataKey, instant)));
    }

    private static Option<String> getMetadataValue(HoodieTableMetaClient metaClient, String extraMetadataKey, HoodieInstant instant) {
        try {
            LOG.info((Object)("reading checkpoint info for:" + instant + " key: " + extraMetadataKey));
            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(metaClient.getCommitsTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            return Option.ofNullable(commitMetadata.getExtraMetadata().get(extraMetadataKey));
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to parse instant metadata " + instant, e);
        }
    }

    private static boolean isClusteringCommit(HoodieTableMetaClient metaClient, HoodieInstant instant) {
        try {
            if ("replacecommit".equals(instant.getAction())) {
                HoodieReplaceCommitMetadata replaceMetadata = HoodieReplaceCommitMetadata.fromBytes(metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieReplaceCommitMetadata.class);
                return WriteOperationType.CLUSTER.equals((Object)replaceMetadata.getOperationType());
            }
            return false;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read instant information: " + instant + " for " + metaClient.getBasePath(), e);
        }
    }

    public static HoodieDefaultTimeline getTimeline(HoodieTableMetaClient metaClient, boolean includeArchivedTimeline) {
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (includeArchivedTimeline) {
            HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
            return archivedTimeline.mergeTimeline(activeTimeline);
        }
        return activeTimeline;
    }
}

