/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.inline.InLineFSUtils;
import org.apache.hudi.common.fs.inline.InLineFileSystem;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieHBaseKVComparator;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieHFileDataBlock
extends HoodieDataBlock {
    private static final Logger LOG = LogManager.getLogger(HoodieHFileDataBlock.class);
    private static final int DEFAULT_BLOCK_SIZE = 0x100000;
    private final Option<Compression.Algorithm> compressionAlgorithm;
    private final Path pathForReader;

    public HoodieHFileDataBlock(FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, boolean enablePointLookups, Path pathForReader) {
        super(content, inputStream, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, "key", enablePointLookups);
        this.compressionAlgorithm = Option.empty();
        this.pathForReader = pathForReader;
    }

    public HoodieHFileDataBlock(List<IndexedRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, Compression.Algorithm compressionAlgorithm, Path pathForReader) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), "key");
        this.compressionAlgorithm = Option.of(compressionAlgorithm);
        this.pathForReader = pathForReader;
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords(List<IndexedRecord> records) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(0x100000).withCompression(this.compressionAlgorithm.get()).withCellComparator((CellComparator)new HoodieHBaseKVComparator()).build();
        Configuration conf = new Configuration();
        CacheConfig cacheConfig = new CacheConfig(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSDataOutputStream ostream = new FSDataOutputStream((OutputStream)baos, null);
        boolean useIntegerKey = !this.getRecordKey(records.get(0)).isPresent();
        int keyWidth = useIntegerKey ? (int)Math.ceil(Math.log(records.size())) + 1 : -1;
        TreeMap<String, byte[]> sortedRecordsMap = new TreeMap<String, byte[]>();
        Iterator<IndexedRecord> itr = records.iterator();
        int id = 0;
        while (itr.hasNext()) {
            IndexedRecord record = itr.next();
            String recordKey2 = useIntegerKey ? String.format("%" + keyWidth + "s", id++) : this.getRecordKey(record).get();
            byte[] recordBytes2 = this.serializeRecord(record);
            ValidationUtils.checkState(!sortedRecordsMap.containsKey(recordKey2), "Writing multiple records with same key not supported for " + this.getClass().getName());
            sortedRecordsMap.put(recordKey2, recordBytes2);
        }
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConfig).withOutputStream(ostream).withFileContext(context).create();
        sortedRecordsMap.forEach((recordKey, recordBytes) -> {
            try {
                KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, recordBytes);
                writer.append((Cell)kv);
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException serializing records", e);
            }
        });
        writer.appendFileInfo("schema".getBytes(), this.getSchema().toString().getBytes());
        writer.close();
        ostream.flush();
        ostream.close();
        return baos.toByteArray();
    }

    @Override
    protected ClosableIterator<IndexedRecord> deserializeRecords(byte[] content) throws IOException {
        ValidationUtils.checkState(this.readerSchema != null, "Reader's schema has to be non-null");
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        final HoodieHFileReader reader = new HoodieHFileReader(null, this.pathForReader, content, Option.of(writerSchema));
        final ClosableIterator recordIterator = reader.getRecordIterator(this.readerSchema);
        return new ClosableIterator<IndexedRecord>(){

            @Override
            public void close() {
                reader.close();
            }

            @Override
            public boolean hasNext() {
                return recordIterator.hasNext();
            }

            @Override
            public IndexedRecord next() {
                return (IndexedRecord)recordIterator.next();
            }
        };
    }

    @Override
    protected ClosableIterator<IndexedRecord> lookupRecords(List<String> keys, boolean fullKey) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        Configuration inlineConf = new Configuration(blockContentLoc.getHadoopConf());
        inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
        inlineConf.setClassLoader(Thread.currentThread().getContextClassLoader());
        Path inlinePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().getFileSystem(inlineConf).getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        final HoodieHFileReader reader = new HoodieHFileReader(inlineConf, inlinePath, new CacheConfig(inlineConf), inlinePath.getFileSystem(inlineConf));
        final ClosableIterator recordIterator = fullKey ? reader.getRecordsByKeysIterator(sortedKeys, this.readerSchema) : reader.getRecordsByKeyPrefixIterator(sortedKeys, this.readerSchema);
        return new ClosableIterator<IndexedRecord>(){

            @Override
            public boolean hasNext() {
                return recordIterator.hasNext();
            }

            @Override
            public IndexedRecord next() {
                return (IndexedRecord)recordIterator.next();
            }

            @Override
            public void close() {
                recordIterator.close();
                reader.close();
            }
        };
    }

    private byte[] serializeRecord(IndexedRecord record) {
        Option<Schema.Field> keyField = this.getKeyField(record.getSchema());
        if (keyField.isPresent()) {
            record.put(keyField.get().pos(), (Object)"");
        }
        return HoodieAvroUtils.indexedRecordToBytes(record);
    }
}

