/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;

public class HoodieCommandBlock
extends HoodieLogBlock {
    private final HoodieCommandBlockTypeEnum type;

    public HoodieCommandBlock(Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(Option.empty(), null, false, Option.empty(), header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
    }

    public HoodieCommandBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.type = HoodieCommandBlockTypeEnum.values()[Integer.parseInt(header.get((Object)HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE))];
    }

    public HoodieCommandBlockTypeEnum getType() {
        return this.type;
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK;
    }

    @Override
    public byte[] getContentBytes() {
        return new byte[0];
    }

    public static enum HoodieCommandBlockTypeEnum {
        ROLLBACK_PREVIOUS_BLOCK;

    }
}

