/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRollingStat;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRollingStatMetadata
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieRollingStatMetadata.class);
    protected Map<String, Map<String, HoodieRollingStat>> partitionToRollingStats = new HashMap<String, Map<String, HoodieRollingStat>>();
    private String actionType = "DUMMY_ACTION";
    public static final String ROLLING_STAT_METADATA_KEY = "ROLLING_STAT";

    public void addRollingStat(String partitionPath, HoodieRollingStat stat) {
        if (!this.partitionToRollingStats.containsKey(partitionPath)) {
            this.partitionToRollingStats.put(partitionPath, new RollingStatsHashMap());
        }
        this.partitionToRollingStats.get(partitionPath).put(stat.getFileId(), stat);
    }

    public HoodieRollingStatMetadata() {
    }

    public HoodieRollingStatMetadata(String actionType) {
        this();
        this.actionType = actionType;
    }

    public static HoodieRollingStatMetadata fromBytes(byte[] bytes) throws IOException {
        return HoodieCommitMetadata.fromBytes(bytes, HoodieRollingStatMetadata.class);
    }

    public String toJsonString() throws IOException {
        if (this.partitionToRollingStats.containsKey(null)) {
            LOG.info((Object)("partition path is null for " + this.partitionToRollingStats.get(null)));
            this.partitionToRollingStats.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public HoodieRollingStatMetadata merge(HoodieRollingStatMetadata rollingStatMetadata) {
        for (Map.Entry<String, Map<String, HoodieRollingStat>> stat : rollingStatMetadata.partitionToRollingStats.entrySet()) {
            for (Map.Entry<String, HoodieRollingStat> innerStat : stat.getValue().entrySet()) {
                this.addRollingStat(stat.getKey(), innerStat.getValue());
            }
        }
        return this;
    }

    public Map<String, Map<String, HoodieRollingStat>> getPartitionToRollingStats() {
        return this.partitionToRollingStats;
    }

    public String getActionType() {
        return this.actionType;
    }

    static class RollingStatsHashMap<K, V>
    extends HashMap<K, V> {
        RollingStatsHashMap() {
        }

        @Override
        public V put(K key, V value) {
            Object v = this.get(key);
            if (v == null) {
                super.put(key, value);
            } else if (v instanceof HoodieRollingStat) {
                long inserts = ((HoodieRollingStat)v).getInserts();
                long upserts = ((HoodieRollingStat)v).getUpserts();
                long deletes = ((HoodieRollingStat)v).getDeletes();
                ((HoodieRollingStat)value).addInserts(inserts);
                ((HoodieRollingStat)value).addUpserts(upserts);
                ((HoodieRollingStat)value).addDeletes(deletes);
                super.put(key, value);
            }
            return value;
        }
    }
}

