/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.Pair;

public interface HoodieData<T>
extends Serializable {
    public void persist(String var1);

    public void unpersist();

    public boolean isEmpty();

    public long count();

    public int getNumPartitions();

    public <O> HoodieData<O> map(SerializableFunction<T, O> var1);

    public <O> HoodieData<O> mapPartitions(SerializableFunction<Iterator<T>, Iterator<O>> var1, boolean var2);

    public <O> HoodieData<O> flatMap(SerializableFunction<T, Iterator<O>> var1);

    public <K, V> HoodiePairData<K, V> mapToPair(SerializablePairFunction<T, K, V> var1);

    public HoodieData<T> distinct();

    public HoodieData<T> distinct(int var1);

    public HoodieData<T> filter(SerializableFunction<T, Boolean> var1);

    public HoodieData<T> union(HoodieData<T> var1);

    public List<T> collectAsList();

    public HoodieData<T> repartition(int var1);

    default public <O> HoodieData<T> distinctWithKey(SerializableFunction<T, O> keyGetter, int parallelism) {
        return this.mapToPair(i -> Pair.of(keyGetter.apply(i), i)).reduceByKey((value1, value2) -> value1, parallelism).values();
    }
}

