/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackHelper;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackHelper;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackRequest;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class ZeroToOneUpgradeHandler
implements UpgradeHandler {
    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        if (commits.size() > 0 && instantTime != null) {
            commits.remove(instantTime);
        }
        for (String commit : commits) {
            this.recreateMarkers(commit, table, context, config.getMarkersDeleteParallelism());
        }
        return Collections.EMPTY_MAP;
    }

    protected void recreateMarkers(String commitInstantTime, HoodieTable table, HoodieEngineContext context, int parallelism) throws HoodieRollbackException {
        try {
            Option commitInstantOpt = Option.fromJavaOptional(table.getActiveTimeline().getCommitsTimeline().getInstants().filter(instant -> HoodieActiveTimeline.EQUALS.test(instant.getTimestamp(), commitInstantTime)).findFirst());
            if (commitInstantOpt.isPresent()) {
                WriteMarkers writeMarkers = WriteMarkersFactory.get(MarkerType.DIRECT, table, commitInstantTime);
                writeMarkers.quietDeleteMarkerDir(context, parallelism);
                List<ListingBasedRollbackRequest> rollbackRequests = table.getMetaClient().getTableType() == HoodieTableType.COPY_ON_WRITE ? RollbackUtils.generateRollbackRequestsByListingCOW(context, table.getMetaClient().getBasePath()) : RollbackUtils.generateRollbackRequestsUsingFileListingMOR((HoodieInstant)commitInstantOpt.get(), table, context);
                List<HoodieRollbackStat> rollbackStats = this.getListBasedRollBackStats(table.getMetaClient(), table.getConfig(), context, (Option<HoodieInstant>)commitInstantOpt, rollbackRequests);
                for (HoodieRollbackStat rollbackStat : rollbackStats) {
                    for (String path : rollbackStat.getSuccessDeleteFiles()) {
                        String dataFileName = path.substring(path.lastIndexOf("/") + 1);
                        writeMarkers.create(rollbackStat.getPartitionPath(), dataFileName, IOType.MERGE);
                    }
                    for (FileStatus fileStatus : rollbackStat.getCommandBlocksCount().keySet()) {
                        writeMarkers.create(rollbackStat.getPartitionPath(), ZeroToOneUpgradeHandler.getFileNameForMarkerFromLogFile(fileStatus.getPath().toString(), table), IOType.APPEND);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Exception thrown while upgrading Hoodie Table from version 0 to 1", e);
        }
    }

    List<HoodieRollbackStat> getListBasedRollBackStats(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context, Option<HoodieInstant> commitInstantOpt, List<ListingBasedRollbackRequest> rollbackRequests) {
        List<HoodieRollbackRequest> hoodieRollbackRequests = new ListingBasedRollbackHelper(metaClient, config).getRollbackRequestsForRollbackPlan(context, (HoodieInstant)commitInstantOpt.get(), rollbackRequests);
        return new BaseRollbackHelper(metaClient, config).collectRollbackStats(context, (HoodieInstant)commitInstantOpt.get(), hoodieRollbackRequests);
    }

    private static String getFileNameForMarkerFromLogFile(String logFilePath, HoodieTable table) {
        Path logPath = new Path(table.getMetaClient().getBasePath(), logFilePath);
        String fileId = FSUtils.getFileIdFromLogPath((Path)logPath);
        String baseInstant = FSUtils.getBaseCommitTimeFromLogPath((Path)logPath);
        String writeToken = FSUtils.getWriteTokenFromLogPath((Path)logPath);
        return FSUtils.makeDataFileName((String)baseInstant, (String)writeToken, (String)fileId, (String)table.getBaseFileFormat().getFileExtension());
    }
}

