/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.table.upgrade.FourToThreeDowngradeHandler;
import org.apache.hudi.table.upgrade.OneToTwoUpgradeHandler;
import org.apache.hudi.table.upgrade.OneToZeroDowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.ThreeToFourUpgradeHandler;
import org.apache.hudi.table.upgrade.ThreeToTwoDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToOneDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToThreeUpgradeHandler;
import org.apache.hudi.table.upgrade.ZeroToOneUpgradeHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class UpgradeDowngrade {
    private static final Logger LOG = LogManager.getLogger(UpgradeDowngrade.class);
    public static final String HOODIE_UPDATED_PROPERTY_FILE = "hoodie.properties.updated";
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private HoodieTableMetaClient metaClient;
    protected HoodieWriteConfig config;
    protected HoodieEngineContext context;
    private transient FileSystem fs;
    private Path updatedPropsFilePath;
    private Path propsFilePath;

    public UpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this.metaClient = metaClient;
        this.config = config;
        this.context = context;
        this.fs = metaClient.getFs();
        this.updatedPropsFilePath = new Path(metaClient.getMetaPath(), HOODIE_UPDATED_PROPERTY_FILE);
        this.propsFilePath = new Path(metaClient.getMetaPath(), "hoodie.properties");
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    public boolean needsUpgradeOrDowngrade(HoodieTableVersion toVersion) {
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        return toVersion.versionCode() != fromVersion.versionCode();
    }

    public void run(HoodieTableVersion toVersion, String instantTime) {
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        if (!this.needsUpgradeOrDowngrade(toVersion)) {
            return;
        }
        LOG.info((Object)("Attempting to move table from version " + fromVersion + " to " + toVersion));
        Hashtable<ConfigProperty, String> tableProps = new Hashtable<ConfigProperty, String>();
        if (fromVersion.versionCode() < toVersion.versionCode()) {
            while (fromVersion.versionCode() < toVersion.versionCode()) {
                HoodieTableVersion nextVersion = HoodieTableVersion.versionFromCode((int)(fromVersion.versionCode() + 1));
                tableProps.putAll(this.upgrade(fromVersion, nextVersion, instantTime));
                fromVersion = nextVersion;
            }
        } else {
            while (fromVersion.versionCode() > toVersion.versionCode()) {
                HoodieTableVersion prevVersion = HoodieTableVersion.versionFromCode((int)(fromVersion.versionCode() - 1));
                tableProps.putAll(this.downgrade(fromVersion, prevVersion, instantTime));
                fromVersion = prevVersion;
            }
        }
        for (Map.Entry entry : tableProps.entrySet()) {
            this.metaClient.getTableConfig().setValue((ConfigProperty)entry.getKey(), (String)entry.getValue());
        }
        this.metaClient.getTableConfig().setTableVersion(toVersion);
        HoodieTableConfig.update((FileSystem)this.metaClient.getFs(), (Path)new Path(this.metaClient.getMetaPath()), (Properties)this.metaClient.getTableConfig().getProps());
    }

    protected Map<ConfigProperty, String> upgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ZERO && toVersion == HoodieTableVersion.ONE) {
            return new ZeroToOneUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.TWO) {
            return new OneToTwoUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.THREE) {
            return new TwoToThreeUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.FOUR) {
            return new ThreeToFourUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), true);
    }

    protected Map<ConfigProperty, String> downgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.ZERO) {
            return new OneToZeroDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.ONE) {
            return new TwoToOneDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.TWO) {
            return new ThreeToTwoDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.THREE) {
            return new FourToThreeDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), false);
    }
}

