/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SavepointActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieSavepointMetadata> {
    private static final Logger LOG = LogManager.getLogger(SavepointActionExecutor.class);
    private final String user;
    private final String comment;

    public SavepointActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String user, String comment) {
        super(context, config, table, instantTime);
        this.user = user;
        this.comment = comment;
    }

    @Override
    public HoodieSavepointMetadata execute() {
        Option cleanInstant = this.table.getCompletedCleanTimeline().lastInstant();
        if (!this.table.getCompletedCommitsTimeline().containsInstant(this.instantTime)) {
            throw new HoodieSavepointException("Could not savepoint non-existing commit " + this.instantTime);
        }
        try {
            String lastCommitRetained;
            if (cleanInstant.isPresent()) {
                HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])this.table.getActiveTimeline().getInstantDetails((HoodieInstant)cleanInstant.get()).get()));
                lastCommitRetained = cleanMetadata.getEarliestCommitToRetain();
            } else {
                lastCommitRetained = ((HoodieInstant)this.table.getCompletedCommitsTimeline().firstInstant().get()).getTimestamp();
            }
            ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)this.instantTime, (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)lastCommitRetained), (String)("Could not savepoint commit " + this.instantTime + " as this is beyond the lookup window " + lastCommitRetained));
            this.context.setJobStatus(this.getClass().getSimpleName(), "Collecting latest files for savepoint " + this.instantTime);
            List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieMetadataConfig)this.config.getMetadataConfig(), (String)this.table.getMetaClient().getBasePath());
            Map latestFilesMap = this.context.mapToPair(partitions, (SerializablePairFunction & Serializable)partitionPath -> {
                LOG.info((Object)("Collecting latest files in partition path " + partitionPath));
                TableFileSystemView.BaseFileOnlyView view = this.table.getBaseFileOnlyView();
                List latestFiles = view.getLatestBaseFilesBeforeOrOn(partitionPath, this.instantTime).map(BaseFile::getFileName).collect(Collectors.toList());
                return new ImmutablePair(partitionPath, latestFiles);
            }, null);
            HoodieSavepointMetadata metadata = TimelineMetadataUtils.convertSavepointMetadata((String)this.user, (String)this.comment, (Map)latestFilesMap);
            this.table.getActiveTimeline().createNewInstant(new HoodieInstant(true, "savepoint", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "savepoint", this.instantTime), TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)metadata));
            LOG.info((Object)("Savepoint " + this.instantTime + " created"));
            return metadata;
        }
        catch (IOException e) {
            throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
        }
    }
}

