/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;

public class BoundedIOCompactionStrategy
extends CompactionStrategy {
    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        ArrayList<HoodieCompactionOperation> finalOperations = new ArrayList<HoodieCompactionOperation>();
        long targetIORemaining = writeConfig.getTargetIOPerCompactionInMB();
        for (HoodieCompactionOperation op : operations) {
            long opIo = ((Double)op.getMetrics().get("TOTAL_IO_MB")).longValue();
            finalOperations.add(op);
            if ((targetIORemaining -= opIo) > 0L) continue;
            return finalOperations;
        }
        return finalOperations;
    }
}

