/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieIndexUtils {
    private static final Logger LOG = LogManager.getLogger(HoodieIndexUtils.class);

    public static List<HoodieBaseFile> getLatestBaseFilesForPartition(String partition, HoodieTable hoodieTable) {
        Option latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
        if (latestCommitTime.isPresent()) {
            return hoodieTable.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partition, ((HoodieInstant)latestCommitTime.get()).getTimestamp()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Pair<String, HoodieBaseFile>> getLatestBaseFilesForAllPartitions(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        context.setJobStatus(HoodieIndexUtils.class.getSimpleName(), "Load latest base files from all partitions");
        return context.flatMap(partitions, (SerializableFunction & Serializable)partitionPath -> {
            List filteredFiles = HoodieIndexUtils.getLatestBaseFilesForPartition(partitionPath, hoodieTable).stream().map(baseFile -> Pair.of((Object)partitionPath, (Object)baseFile)).collect(Collectors.toList());
            return filteredFiles.stream();
        }, Math.max(partitions.size(), 1));
    }

    public static HoodieRecord getTaggedRecord(HoodieRecord inputRecord, Option<HoodieRecordLocation> location) {
        HoodieRecord record = inputRecord;
        if (location.isPresent()) {
            record = inputRecord.newInstance();
            record.unseal();
            record.setCurrentLocation((HoodieRecordLocation)location.get());
            record.seal();
        }
        return record;
    }

    public static List<String> filterKeysFromFile(Path filePath, List<String> candidateRecordKeys, Configuration configuration) throws HoodieIndexException {
        ValidationUtils.checkArgument((boolean)FSUtils.isBaseFile((Path)filePath));
        ArrayList<String> foundRecordKeys = new ArrayList<String>();
        try {
            if (!candidateRecordKeys.isEmpty()) {
                HoodieTimer timer = new HoodieTimer().startTimer();
                HoodieFileReader fileReader = HoodieFileReaderFactory.getFileReader((Configuration)configuration, (Path)filePath);
                Set fileRowKeys = fileReader.filterRowKeys(new TreeSet<String>(candidateRecordKeys));
                foundRecordKeys.addAll(fileRowKeys);
                LOG.info((Object)String.format("Checked keys against file %s, in %d ms. #candidates (%d) #found (%d)", filePath, timer.endTimer(), candidateRecordKeys.size(), foundRecordKeys.size()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Keys matching for file " + filePath + " => " + foundRecordKeys));
                }
            }
        }
        catch (Exception e) {
            throw new HoodieIndexException("Error checking candidate keys against file.", (Throwable)e);
        }
        return foundRecordKeys;
    }
}

