/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;

@ConfigClassProperty(name="Locks Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configs that control locking mechanisms required for concurrency control  between writers to a Hudi table. Concurrency between Hudi's own table services  are auto managed internally.")
public class HoodieLockConfig
extends HoodieConfig {
    public static final ConfigProperty<String> LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS = ConfigProperty.key((String)"hoodie.write.lock.wait_time_ms_between_retry").defaultValue((Object)LockConfiguration.DEFAULT_LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS).sinceVersion("0.8.0").withDocumentation("Initial amount of time to wait between retries to acquire locks,  subsequent retries will exponentially backoff.");
    public static final ConfigProperty<String> LOCK_ACQUIRE_RETRY_MAX_WAIT_TIME_IN_MILLIS = ConfigProperty.key((String)"hoodie.write.lock.max_wait_time_ms_between_retry").defaultValue((Object)String.valueOf(5000L)).sinceVersion("0.8.0").withDocumentation("Maximum amount of time to wait between retries by lock provider client. This bounds the maximum delay from the exponential backoff. Currently used by ZK based lock provider only.");
    public static final ConfigProperty<String> LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS = ConfigProperty.key((String)"hoodie.write.lock.client.wait_time_ms_between_retry").defaultValue((Object)String.valueOf(10000L)).sinceVersion("0.8.0").withDocumentation("Amount of time to wait between retries on the lock provider by the lock manager");
    public static final ConfigProperty<String> LOCK_ACQUIRE_NUM_RETRIES = ConfigProperty.key((String)"hoodie.write.lock.num_retries").defaultValue((Object)LockConfiguration.DEFAULT_LOCK_ACQUIRE_NUM_RETRIES).sinceVersion("0.8.0").withDocumentation("Maximum number of times to retry lock acquire, at each lock provider");
    public static final ConfigProperty<String> LOCK_ACQUIRE_CLIENT_NUM_RETRIES = ConfigProperty.key((String)"hoodie.write.lock.client.num_retries").defaultValue((Object)String.valueOf(10)).sinceVersion("0.8.0").withDocumentation("Maximum number of times to retry to acquire lock additionally from the lock manager.");
    public static final ConfigProperty<Integer> LOCK_ACQUIRE_WAIT_TIMEOUT_MS = ConfigProperty.key((String)"hoodie.write.lock.wait_time_ms").defaultValue((Object)60000).sinceVersion("0.8.0").withDocumentation("Timeout in ms, to wait on an individual lock acquire() call, at the lock provider.");
    public static final ConfigProperty<String> FILESYSTEM_LOCK_PATH = ConfigProperty.key((String)"hoodie.write.lock.filesystem.path").noDefaultValue().sinceVersion("0.8.0").withDocumentation("For DFS based lock providers, path to store the locks under.");
    public static final ConfigProperty<String> HIVE_DATABASE_NAME = ConfigProperty.key((String)"hoodie.write.lock.hivemetastore.database").noDefaultValue().sinceVersion("0.8.0").withDocumentation("For Hive based lock provider, the Hive database to acquire lock against");
    public static final ConfigProperty<String> HIVE_TABLE_NAME = ConfigProperty.key((String)"hoodie.write.lock.hivemetastore.table").noDefaultValue().sinceVersion("0.8.0").withDocumentation("For Hive based lock provider, the Hive table to acquire lock against");
    public static final ConfigProperty<String> HIVE_METASTORE_URI = ConfigProperty.key((String)"hoodie.write.lock.hivemetastore.uris").noDefaultValue().sinceVersion("0.8.0").withDocumentation("For Hive based lock provider, the Hive metastore URI to acquire locks against.");
    public static final ConfigProperty<String> ZK_BASE_PATH = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.base_path").noDefaultValue().sinceVersion("0.8.0").withDocumentation("The base path on Zookeeper under which to create lock related ZNodes. This should be same for all concurrent writers to the same table");
    public static final ConfigProperty<Integer> ZK_SESSION_TIMEOUT_MS = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.session_timeout_ms").defaultValue((Object)60000).sinceVersion("0.8.0").withDocumentation("Timeout in ms, to wait after losing connection to ZooKeeper, before the session is expired");
    public static final ConfigProperty<Integer> ZK_CONNECTION_TIMEOUT_MS = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.connection_timeout_ms").defaultValue((Object)15000).sinceVersion("0.8.0").withDocumentation("Timeout in ms, to wait for establishing connection with Zookeeper.");
    public static final ConfigProperty<String> ZK_CONNECT_URL = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.url").noDefaultValue().sinceVersion("0.8.0").withDocumentation("Zookeeper URL to connect to.");
    public static final ConfigProperty<String> ZK_PORT = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.port").noDefaultValue().sinceVersion("0.8.0").withDocumentation("Zookeeper port to connect to.");
    public static final ConfigProperty<String> ZK_LOCK_KEY = ConfigProperty.key((String)"hoodie.write.lock.zookeeper.lock_key").noDefaultValue().withInferFunction(p -> Option.ofNullable((Object)p.getStringOrDefault(HoodieWriteConfig.TBL_NAME, null))).sinceVersion("0.8.0").withDocumentation("Key name under base_path at which to create a ZNode and acquire lock. Final path on zk will look like base_path/lock_key. If this parameter is not set, we would set it as the table name");
    public static final ConfigProperty<String> LOCK_PROVIDER_CLASS_NAME = ConfigProperty.key((String)"hoodie.write.lock.provider").defaultValue((Object)ZookeeperBasedLockProvider.class.getName()).sinceVersion("0.8.0").withDocumentation("Lock provider class name, user can provide their own implementation of LockProvider which should be subclass of org.apache.hudi.common.lock.LockProvider");
    public static final ConfigProperty<String> WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME = ConfigProperty.key((String)"hoodie.write.lock.conflict.resolution.strategy").defaultValue((Object)SimpleConcurrentFileWritesConflictResolutionStrategy.class.getName()).sinceVersion("0.8.0").withDocumentation("Lock provider class name, this should be subclass of org.apache.hudi.client.transaction.ConflictResolutionStrategy");
    @Deprecated
    public static final String WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_PROP = WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS = (String)WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String LOCK_PROVIDER_CLASS_PROP = LOCK_PROVIDER_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_LOCK_PROVIDER_CLASS = (String)LOCK_PROVIDER_CLASS_NAME.defaultValue();

    private HoodieLockConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieLockConfig lockConfig = new HoodieLockConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.lockConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.lockConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withLockProvider(Class<? extends LockProvider> lockProvider) {
            this.lockConfig.setValue(LOCK_PROVIDER_CLASS_NAME, lockProvider.getName());
            return this;
        }

        public Builder withHiveDatabaseName(String databaseName) {
            this.lockConfig.setValue(HIVE_DATABASE_NAME, databaseName);
            return this;
        }

        public Builder withHiveTableName(String tableName) {
            this.lockConfig.setValue(HIVE_TABLE_NAME, tableName);
            return this;
        }

        public Builder withHiveMetastoreURIs(String hiveMetastoreURIs) {
            this.lockConfig.setValue(HIVE_METASTORE_URI, hiveMetastoreURIs);
            return this;
        }

        public Builder withZkQuorum(String zkQuorum) {
            this.lockConfig.setValue(ZK_CONNECT_URL, zkQuorum);
            return this;
        }

        public Builder withZkBasePath(String zkBasePath) {
            this.lockConfig.setValue(ZK_BASE_PATH, zkBasePath);
            return this;
        }

        public Builder withZkPort(String zkPort) {
            this.lockConfig.setValue(ZK_PORT, zkPort);
            return this;
        }

        public Builder withZkLockKey(String zkLockKey) {
            this.lockConfig.setValue(ZK_LOCK_KEY, zkLockKey);
            return this;
        }

        public Builder withZkConnectionTimeoutInMs(Long connectionTimeoutInMs) {
            this.lockConfig.setValue(ZK_CONNECTION_TIMEOUT_MS, String.valueOf(connectionTimeoutInMs));
            return this;
        }

        public Builder withZkSessionTimeoutInMs(Long sessionTimeoutInMs) {
            this.lockConfig.setValue(ZK_SESSION_TIMEOUT_MS, String.valueOf(sessionTimeoutInMs));
            return this;
        }

        public Builder withNumRetries(int numRetries) {
            this.lockConfig.setValue(LOCK_ACQUIRE_NUM_RETRIES, String.valueOf(numRetries));
            return this;
        }

        public Builder withRetryWaitTimeInMillis(Long retryWaitTimeInMillis) {
            this.lockConfig.setValue(LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS, String.valueOf(retryWaitTimeInMillis));
            return this;
        }

        public Builder withRetryMaxWaitTimeInMillis(Long retryMaxWaitTimeInMillis) {
            this.lockConfig.setValue(LOCK_ACQUIRE_RETRY_MAX_WAIT_TIME_IN_MILLIS, String.valueOf(retryMaxWaitTimeInMillis));
            return this;
        }

        public Builder withClientNumRetries(int clientNumRetries) {
            this.lockConfig.setValue(LOCK_ACQUIRE_CLIENT_NUM_RETRIES, String.valueOf(clientNumRetries));
            return this;
        }

        public Builder withClientRetryWaitTimeInMillis(Long clientRetryWaitTimeInMillis) {
            this.lockConfig.setValue(LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS, String.valueOf(clientRetryWaitTimeInMillis));
            return this;
        }

        public Builder withLockWaitTimeInMillis(Long waitTimeInMillis) {
            this.lockConfig.setValue(LOCK_ACQUIRE_WAIT_TIMEOUT_MS, String.valueOf(waitTimeInMillis));
            return this;
        }

        public Builder withConflictResolutionStrategy(ConflictResolutionStrategy conflictResolutionStrategy) {
            this.lockConfig.setValue(WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME, conflictResolutionStrategy.getClass().getName());
            return this;
        }

        public HoodieLockConfig build() {
            this.lockConfig.setDefaults(HoodieLockConfig.class.getName());
            return this.lockConfig;
        }
    }
}

