/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.net.InetSocketAddress;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, "ThriftBinaryCLIService");
    }

    @Override
    public void run() {
        try {
            hiveAuthFactory = new HiveAuthFactory();
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
            String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
            if (hiveHost == null) {
                hiveHost = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            }
            this.serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, this.portNum) : new InetSocketAddress(this.portNum);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(this.serverAddress)).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(this.minWorkerThreads).maxWorkerThreads(this.maxWorkerThreads);
            this.server = new TThreadPoolServer(sargs);
            LOG.info((Object)("ThriftBinaryCLIService listening on " + this.serverAddress));
            this.server.serve();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error: ", t);
        }
    }
}

