/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplSqlSessionState;
import org.apache.hive.hplsql.HplsqlBaseVisitor;
import org.apache.hive.hplsql.HplsqlLexer;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.BuiltinFunctions;
import org.apache.hive.hplsql.functions.FunctionRegistry;
import org.apache.hive.hplsql.functions.InMemoryFunctionRegistry;
import org.apache.thrift.TException;

public class HmsFunctionRegistry
implements FunctionRegistry {
    private Exec exec;
    private boolean trace;
    private IMetaStoreClient msc;
    private BuiltinFunctions builtinFunctions;
    private HplSqlSessionState hplSqlSession;
    private Map<String, ParserRuleContext> cache = new HashMap<String, ParserRuleContext>();

    public HmsFunctionRegistry(Exec e, IMetaStoreClient msc, BuiltinFunctions builtinFunctions, HplSqlSessionState hplSqlSession) {
        this.exec = e;
        this.msc = msc;
        this.builtinFunctions = builtinFunctions;
        this.hplSqlSession = hplSqlSession;
        this.trace = this.exec.getTrace();
    }

    @Override
    public boolean exists(String name) {
        return this.isCached(name) || this.getProcFromHMS(name).isPresent();
    }

    @Override
    public void remove(String name) {
        try {
            this.msc.dropStoredProcedure(new StoredProcedureRequest(this.hplSqlSession.currentCatalog(), this.hplSqlSession.currentDatabase(), name));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isCached(String name) {
        return this.cache.containsKey(this.qualified(name));
    }

    private String qualified(String name) {
        return (this.hplSqlSession.currentDatabase() + "." + name).toUpperCase();
    }

    @Override
    public boolean exec(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        if (this.builtinFunctions.exec(name, ctx)) {
            return true;
        }
        if (this.isCached(name)) {
            this.trace(ctx, "EXEC CACHED FUNCTION " + name);
            this.execProcOrFunc(ctx, this.cache.get(this.qualified(name)), name);
            return true;
        }
        Optional<StoredProcedure> proc = this.getProcFromHMS(name);
        if (proc.isPresent()) {
            this.trace(ctx, "EXEC HMS FUNCTION " + name);
            ParserRuleContext procCtx = this.parse(proc.get());
            this.execProcOrFunc(ctx, procCtx, name);
            this.saveInCache(name, procCtx);
            return true;
        }
        return false;
    }

    private void execProcOrFunc(HplsqlParser.Expr_func_paramsContext ctx, ParserRuleContext procCtx, String name) {
        this.exec.callStackPush(name);
        HashMap<String, Var> out = new HashMap<String, Var>();
        ArrayList<Var> actualParams = this.getActualCallParameters(ctx);
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.callWithParameters(ctx, procCtx, out, actualParams);
        this.exec.callStackPop();
        this.exec.leaveScope();
        for (Map.Entry<String, Var> i : out.entrySet()) {
            this.exec.setVariable(i.getKey(), i.getValue());
        }
    }

    private void callWithParameters(HplsqlParser.Expr_func_paramsContext ctx, ParserRuleContext procCtx, HashMap<String, Var> out, ArrayList<Var> actualParams) {
        if (procCtx instanceof HplsqlParser.Create_function_stmtContext) {
            HplsqlParser.Create_function_stmtContext func = (HplsqlParser.Create_function_stmtContext)procCtx;
            InMemoryFunctionRegistry.setCallParameters(func.ident().getText(), ctx, actualParams, func.create_routine_params(), null, this.exec);
            if (func.declare_block_inplace() != null) {
                this.exec.visit((ParseTree)func.declare_block_inplace());
            }
            this.exec.visit((ParseTree)func.single_block_stmt());
        } else {
            HplsqlParser.Create_procedure_stmtContext proc = (HplsqlParser.Create_procedure_stmtContext)procCtx;
            InMemoryFunctionRegistry.setCallParameters(proc.ident(0).getText(), ctx, actualParams, proc.create_routine_params(), out, this.exec);
            this.exec.visit((ParseTree)proc.proc_block());
        }
    }

    private ParserRuleContext parse(StoredProcedure proc) {
        HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream(proc.getSource()));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HplsqlParser parser = new HplsqlParser((TokenStream)tokens);
        ProcVisitor visitor = new ProcVisitor();
        parser.program().accept(visitor);
        return visitor.func != null ? visitor.func : visitor.proc;
    }

    private Optional<StoredProcedure> getProcFromHMS(String name) {
        try {
            StoredProcedureRequest request = new StoredProcedureRequest(this.hplSqlSession.currentCatalog(), this.hplSqlSession.currentDatabase(), name);
            return Optional.ofNullable(this.msc.getStoredProcedure(request));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private ArrayList<Var> getActualCallParameters(HplsqlParser.Expr_func_paramsContext actual) {
        if (actual == null || actual.func_param() == null) {
            return null;
        }
        int cnt = actual.func_param().size();
        ArrayList<Var> values = new ArrayList<Var>(cnt);
        for (int i = 0; i < cnt; ++i) {
            values.add(this.evalPop(actual.func_param(i).expr()));
        }
        return values;
    }

    @Override
    public void addUserFunction(HplsqlParser.Create_function_stmtContext ctx) {
        String name = ctx.ident().getText().toUpperCase();
        if (this.builtinFunctions.exists(name)) {
            this.exec.info(ctx, name + " is a built-in function which cannot be redefined.");
            return;
        }
        this.trace(ctx, "CREATE FUNCTION " + name);
        StoredProcedure proc = this.newStoredProc(name, Exec.getFormattedText(ctx));
        this.saveInCache(name, ctx);
        this.saveStoredProcInHMS(proc);
    }

    @Override
    public void addUserProcedure(HplsqlParser.Create_procedure_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        if (this.builtinFunctions.exists(name)) {
            this.exec.info(ctx, name + " is a built-in function which cannot be redefined.");
            return;
        }
        this.trace(ctx, "CREATE PROCEDURE " + name);
        StoredProcedure proc = this.newStoredProc(name, Exec.getFormattedText(ctx));
        this.saveInCache(name, ctx);
        this.saveStoredProcInHMS(proc);
    }

    private void saveInCache(String name, ParserRuleContext procCtx) {
        this.cache.put(this.qualified(name), procCtx);
    }

    private void saveStoredProcInHMS(StoredProcedure proc) {
        try {
            this.msc.createStoredProcedure(proc);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private StoredProcedure newStoredProc(String name, String source) {
        StoredProcedure storedProcedure = new StoredProcedure();
        storedProcedure.setCatName(this.hplSqlSession.currentCatalog());
        storedProcedure.setName(name);
        storedProcedure.setOwnerName(this.hplSqlSession.currentUser());
        storedProcedure.setDbName(this.hplSqlSession.currentDatabase());
        storedProcedure.setSource(source);
        return storedProcedure;
    }

    private Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        return this.exec.stackPop();
    }

    private void trace(ParserRuleContext ctx, String message) {
        if (this.trace) {
            this.exec.trace(ctx, message);
        }
    }

    private static class ProcVisitor
    extends HplsqlBaseVisitor<Void> {
        HplsqlParser.Create_function_stmtContext func;
        HplsqlParser.Create_procedure_stmtContext proc;

        private ProcVisitor() {
        }

        @Override
        public Void visitCreate_procedure_stmt(HplsqlParser.Create_procedure_stmtContext ctx) {
            this.proc = ctx;
            return null;
        }

        @Override
        public Void visitCreate_function_stmt(HplsqlParser.Create_function_stmtContext ctx) {
            this.func = ctx;
            return null;
        }
    }
}

