/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.executor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.hplsql.executor.RowResult;

public class QueryResult {
    private final RowResult rows;
    private final java.util.function.Supplier<Metadata> metadata;
    private final Exception exception;

    public QueryResult(RowResult rows, java.util.function.Supplier<Metadata> metadata, Exception exception) {
        this.rows = rows;
        this.metadata = QueryResult.memoize(metadata);
        this.exception = exception;
    }

    public boolean next() {
        return this.rows.next();
    }

    public int columnCount() {
        return this.metadata().columnCount();
    }

    public <T> T column(int columnIndex, Class<T> type) {
        return this.rows.get(columnIndex, type);
    }

    public boolean error() {
        return this.exception != null;
    }

    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        }
    }

    public Exception exception() {
        return this.exception;
    }

    public Metadata metadata() {
        return this.metadata.get();
    }

    public int jdbcType(int columnIndex) {
        return this.metadata().jdbcType(columnIndex);
    }

    public void close() {
        if (this.rows != null) {
            this.rows.close();
        }
    }

    private static <T> java.util.function.Supplier<T> memoize(java.util.function.Supplier<? extends T> supplier) {
        return () -> ((Supplier)Suppliers.memoize(supplier::get)).get();
    }

    public String errorText() {
        if (this.exception != null) {
            if (this.exception instanceof ClassNotFoundException) {
                return "ClassNotFoundException: " + this.exception.getMessage();
            }
            return this.exception.getMessage();
        }
        return "";
    }
}

