/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

class SchemaToTypeInfo {
    private static final Map<Schema.Type, TypeInfo> primitiveTypeToTypeInfo = SchemaToTypeInfo.initTypeMap();
    static InstanceCache<Schema, TypeInfo> typeInfoCache = new InstanceCache<Schema, TypeInfo>(){

        @Override
        protected TypeInfo makeInstance(Schema s, Set<Schema> seenSchemas) throws AvroSerdeException {
            return SchemaToTypeInfo.generateTypeInfoWorker(s, seenSchemas);
        }
    };

    SchemaToTypeInfo() {
    }

    private static Map<Schema.Type, TypeInfo> initTypeMap() {
        Hashtable<Schema.Type, PrimitiveTypeInfo> theMap = new Hashtable<Schema.Type, PrimitiveTypeInfo>();
        theMap.put(Schema.Type.NULL, TypeInfoFactory.getPrimitiveTypeInfo("void"));
        theMap.put(Schema.Type.BOOLEAN, TypeInfoFactory.getPrimitiveTypeInfo("boolean"));
        theMap.put(Schema.Type.INT, TypeInfoFactory.getPrimitiveTypeInfo("int"));
        theMap.put(Schema.Type.LONG, TypeInfoFactory.getPrimitiveTypeInfo("bigint"));
        theMap.put(Schema.Type.FLOAT, TypeInfoFactory.getPrimitiveTypeInfo("float"));
        theMap.put(Schema.Type.DOUBLE, TypeInfoFactory.getPrimitiveTypeInfo("double"));
        theMap.put(Schema.Type.BYTES, TypeInfoFactory.getPrimitiveTypeInfo("binary"));
        theMap.put(Schema.Type.FIXED, TypeInfoFactory.getPrimitiveTypeInfo("binary"));
        theMap.put(Schema.Type.STRING, TypeInfoFactory.getPrimitiveTypeInfo("string"));
        return Collections.unmodifiableMap(theMap);
    }

    public static List<TypeInfo> generateColumnTypes(Schema schema) throws AvroSerdeException {
        return SchemaToTypeInfo.generateColumnTypes(schema, null);
    }

    public static List<TypeInfo> generateColumnTypes(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        List<Schema.Field> fields = schema.getFields();
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(fields.size());
        for (Schema.Field field : fields) {
            types.add(SchemaToTypeInfo.generateTypeInfo(field.schema(), seenSchemas));
        }
        return types;
    }

    public static TypeInfo generateTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.BYTES && "decimal".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int precision = 0;
            int scale = 0;
            try {
                precision = schema.getJsonProp("precision").getIntValue();
                scale = schema.getJsonProp("scale").getIntValue();
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain scale value from file schema: " + schema, ex);
            }
            try {
                HiveDecimalUtils.validateParameter(precision, scale);
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Invalid precision or scale for decimal type", ex);
            }
            return TypeInfoFactory.getDecimalTypeInfo(precision, scale);
        }
        if (type == Schema.Type.STRING && "char".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = schema.getJsonProp("maxLength").getValueAsInt();
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, ex);
            }
            return TypeInfoFactory.getCharTypeInfo(maxLength);
        }
        if (type == Schema.Type.STRING && "varchar".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = schema.getJsonProp("maxLength").getValueAsInt();
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, ex);
            }
            return TypeInfoFactory.getVarcharTypeInfo(maxLength);
        }
        if (type == Schema.Type.INT && "date".equals(schema.getProp("logicalType"))) {
            return TypeInfoFactory.dateTypeInfo;
        }
        if (type == Schema.Type.LONG && "timestamp-millis".equals(schema.getProp("logicalType"))) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        return typeInfoCache.retrieve(schema, seenSchemas);
    }

    private static TypeInfo generateTypeInfoWorker(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        if (AvroSerdeUtils.isNullableType(schema)) {
            return SchemaToTypeInfo.generateTypeInfo(AvroSerdeUtils.getOtherTypeFromNullableType(schema), seenSchemas);
        }
        Schema.Type type = schema.getType();
        if (primitiveTypeToTypeInfo.containsKey((Object)type)) {
            return primitiveTypeToTypeInfo.get((Object)type);
        }
        switch (type) {
            case RECORD: {
                return SchemaToTypeInfo.generateRecordTypeInfo(schema, seenSchemas);
            }
            case MAP: {
                return SchemaToTypeInfo.generateMapTypeInfo(schema, seenSchemas);
            }
            case ARRAY: {
                return SchemaToTypeInfo.generateArrayTypeInfo(schema, seenSchemas);
            }
            case UNION: {
                return SchemaToTypeInfo.generateUnionTypeInfo(schema, seenSchemas);
            }
            case ENUM: {
                return SchemaToTypeInfo.generateEnumTypeInfo(schema);
            }
        }
        throw new AvroSerdeException("Do not yet support: " + schema);
    }

    private static TypeInfo generateRecordTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.RECORD));
        if (seenSchemas == null) {
            seenSchemas = Collections.newSetFromMap(new IdentityHashMap());
        } else if (seenSchemas.contains(schema)) {
            throw new AvroSerdeException("Recursive schemas are not supported. Recursive schema was " + schema.getFullName());
        }
        seenSchemas.add(schema);
        List<Schema.Field> fields = schema.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldNames.add(i, fields.get(i).name());
            typeInfos.add(i, SchemaToTypeInfo.generateTypeInfo(fields.get(i).schema(), seenSchemas));
        }
        return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
    }

    private static TypeInfo generateMapTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.MAP));
        Schema valueType = schema.getValueType();
        TypeInfo ti = SchemaToTypeInfo.generateTypeInfo(valueType, seenSchemas);
        return TypeInfoFactory.getMapTypeInfo(TypeInfoFactory.getPrimitiveTypeInfo("string"), ti);
    }

    private static TypeInfo generateArrayTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.ARRAY));
        Schema itemsType = schema.getElementType();
        TypeInfo itemsTypeInfo = SchemaToTypeInfo.generateTypeInfo(itemsType, seenSchemas);
        return TypeInfoFactory.getListTypeInfo(itemsTypeInfo);
    }

    private static TypeInfo generateUnionTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.UNION));
        List<Schema> types = schema.getTypes();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(types.size());
        for (Schema type : types) {
            typeInfos.add(SchemaToTypeInfo.generateTypeInfo(type, seenSchemas));
        }
        return TypeInfoFactory.getUnionTypeInfo(typeInfos);
    }

    private static TypeInfo generateEnumTypeInfo(Schema schema) {
        assert (schema.getType().equals((Object)Schema.Type.ENUM));
        return TypeInfoFactory.getPrimitiveTypeInfo("string");
    }
}

