/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.DataWritableRecordConverter;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.ql.optimizer.NestedColumnFieldPruningUtils;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class DataWritableReadSupport
extends ReadSupport<ArrayWritable> {
    public static final String HIVE_TABLE_AS_PARQUET_SCHEMA = "HIVE_TABLE_SCHEMA";
    public static final String PARQUET_COLUMN_INDEX_ACCESS = "parquet.column.index.access";
    private TypeInfo hiveTypeInfo;

    public static List<String> getColumnNames(String columns) {
        return (List)VirtualColumn.removeVirtualColumns(StringUtils.getStringCollection((String)columns));
    }

    public static List<TypeInfo> getColumnTypes(String types) {
        return TypeInfoUtils.getTypeInfosFromTypeString(types);
    }

    private static Type getFieldTypeIgnoreCase(GroupType groupType, String fieldName) {
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(fieldName)) continue;
            return type;
        }
        return null;
    }

    private static List<Type> getProjectedGroupFields(GroupType schema, List<String> colNames, List<TypeInfo> colTypes) {
        ArrayList<Type> schemaTypes = new ArrayList<Type>();
        ListIterator<String> columnIterator = colNames.listIterator();
        while (columnIterator.hasNext()) {
            TypeInfo colType = colTypes.get(columnIterator.nextIndex());
            String colName = columnIterator.next();
            Type fieldType = DataWritableReadSupport.getFieldTypeIgnoreCase(schema, colName);
            if (fieldType == null) {
                schemaTypes.add((Type)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).named(colName));
                continue;
            }
            schemaTypes.add(DataWritableReadSupport.getProjectedType(colType, fieldType));
        }
        return schemaTypes;
    }

    private static Type getProjectedType(TypeInfo colType, Type fieldType) {
        switch (colType.getCategory()) {
            case STRUCT: {
                List<Type> groupFields = DataWritableReadSupport.getProjectedGroupFields(fieldType.asGroupType(), ((StructTypeInfo)colType).getAllStructFieldNames(), ((StructTypeInfo)colType).getAllStructFieldTypeInfos());
                Type[] typesArray = groupFields.toArray(new Type[0]);
                return (Type)((Types.GroupBuilder)Types.buildGroup(fieldType.getRepetition()).addFields(typesArray)).named(fieldType.getName());
            }
            case LIST: {
                Type subFieldType;
                TypeInfo elemType = ((ListTypeInfo)colType).getListElementTypeInfo();
                if (elemType.getCategory() != ObjectInspector.Category.STRUCT || (subFieldType = fieldType.asGroupType().getType(0)).isPrimitive()) break;
                String subFieldName = subFieldType.getName();
                Text name = new Text(subFieldName);
                subFieldType = name.equals((Object)ParquetHiveSerDe.ARRAY) || name.equals((Object)ParquetHiveSerDe.LIST) ? new GroupType(Type.Repetition.REPEATED, subFieldName, DataWritableReadSupport.getProjectedType(elemType, subFieldType.asGroupType().getType(0))) : DataWritableReadSupport.getProjectedType(elemType, subFieldType);
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(Type.Repetition.OPTIONAL).as(OriginalType.LIST)).addFields(subFieldType)).named(fieldType.getName());
            }
        }
        return fieldType;
    }

    public static MessageType getSchemaByName(MessageType schema, List<String> colNames, List<TypeInfo> colTypes) {
        List<Type> projectedFields = DataWritableReadSupport.getProjectedGroupFields(schema, colNames, colTypes);
        Type[] typesArray = projectedFields.toArray(new Type[0]);
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(typesArray)).named(schema.getName());
    }

    public static MessageType getSchemaByIndex(MessageType schema, List<String> colNames, List<Integer> colIndexes) {
        ArrayList<Type> schemaTypes = new ArrayList<Type>();
        for (Integer i : colIndexes) {
            if (i >= colNames.size()) continue;
            if (i < schema.getFieldCount()) {
                schemaTypes.add(schema.getType(i));
                continue;
            }
            schemaTypes.add((Type)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).named("_mask_" + colNames.get(i)));
        }
        return new MessageType(schema.getName(), schemaTypes);
    }

    public static MessageType getProjectedSchema(MessageType schema, List<String> colNames, List<Integer> colIndexes, Set<String> nestedColumnPaths) {
        ArrayList<Type> schemaTypes = new ArrayList<Type>();
        Map<String, FieldNode> prunedCols = DataWritableReadSupport.getPrunedNestedColumns(nestedColumnPaths);
        for (Integer i : colIndexes) {
            if (i >= colNames.size()) continue;
            if (i < schema.getFieldCount()) {
                Type t = schema.getType(i);
                String tn = t.getName().toLowerCase();
                if (!prunedCols.containsKey(tn)) {
                    schemaTypes.add(schema.getType(i));
                    continue;
                }
                if (t.isPrimitive()) {
                    schemaTypes.add(t);
                    continue;
                }
                List<Type> g = DataWritableReadSupport.projectLeafTypes(Arrays.asList(t), Arrays.asList(prunedCols.get(tn)));
                if (g.isEmpty()) continue;
                schemaTypes.addAll(g);
                continue;
            }
            schemaTypes.add((Type)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).named("_mask_" + colNames.get(i)));
        }
        return new MessageType(schema.getName(), schemaTypes);
    }

    private static Map<String, FieldNode> getPrunedNestedColumns(Set<String> nestedColPaths) {
        HashMap<String, FieldNode> resMap = new HashMap<String, FieldNode>();
        if (nestedColPaths.isEmpty()) {
            return resMap;
        }
        for (String s : nestedColPaths) {
            String c = StringUtils.split((String)s, (char)'.')[0].toLowerCase();
            if (!resMap.containsKey(c)) {
                FieldNode f = NestedColumnFieldPruningUtils.addNodeByPath(null, s);
                resMap.put(c, f);
                continue;
            }
            resMap.put(c, NestedColumnFieldPruningUtils.addNodeByPath((FieldNode)resMap.get(c), s));
        }
        return resMap;
    }

    private static GroupType buildProjectedGroupType(GroupType originalType, List<Type> types) {
        if (types == null || types.isEmpty()) {
            return null;
        }
        return new GroupType(originalType.getRepetition(), originalType.getName(), types);
    }

    private static List<Type> projectLeafTypes(List<Type> types, List<FieldNode> nodes) {
        ArrayList<Type> res = new ArrayList<Type>();
        if (nodes.isEmpty()) {
            return res;
        }
        HashMap<String, FieldNode> fieldMap = new HashMap<String, FieldNode>();
        for (FieldNode n : nodes) {
            fieldMap.put(n.getFieldName().toLowerCase(), n);
        }
        for (Type type : types) {
            String tn = type.getName().toLowerCase();
            if (!fieldMap.containsKey(tn)) continue;
            FieldNode f = (FieldNode)fieldMap.get(tn);
            if (f.getNodes().isEmpty()) {
                res.add(type);
                continue;
            }
            if (type instanceof GroupType) {
                List<Type> ts;
                GroupType groupType = type.asGroupType();
                GroupType g = DataWritableReadSupport.buildProjectedGroupType(groupType, ts = DataWritableReadSupport.projectLeafTypes(groupType.getFields(), f.getNodes()));
                if (g == null) continue;
                res.add(g);
                continue;
            }
            throw new RuntimeException("Primitive type " + f.getFieldName() + "should not " + "doesn't match type" + f.toString());
        }
        return res;
    }

    @Override
    public ReadSupport.ReadContext init(InitContext context) {
        Configuration configuration = context.getConfiguration();
        MessageType fileSchema = context.getFileSchema();
        String columnNames = configuration.get("columns");
        HashMap<String, String> contextMetadata = new HashMap<String, String>();
        boolean indexAccess = configuration.getBoolean(PARQUET_COLUMN_INDEX_ACCESS, false);
        if (columnNames != null) {
            MessageType tableSchema;
            List<String> columnNamesList = DataWritableReadSupport.getColumnNames(columnNames);
            String columnTypes = configuration.get("columns.types");
            List<TypeInfo> columnTypesList = DataWritableReadSupport.getColumnTypes(columnTypes);
            if (indexAccess) {
                ArrayList<Integer> indexSequence = new ArrayList<Integer>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    indexSequence.add(i);
                }
                tableSchema = DataWritableReadSupport.getSchemaByIndex(fileSchema, columnNamesList, indexSequence);
            } else {
                tableSchema = DataWritableReadSupport.getSchemaByName(fileSchema, columnNamesList, columnTypesList);
            }
            contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, tableSchema.toString());
            contextMetadata.put(PARQUET_COLUMN_INDEX_ACCESS, String.valueOf(indexAccess));
            this.hiveTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNamesList, columnTypesList);
            Set<String> groupPaths = ColumnProjectionUtils.getNestedColumnPaths(configuration);
            List<Integer> indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs(configuration);
            if (!ColumnProjectionUtils.isReadAllColumns(configuration) && !indexColumnsWanted.isEmpty()) {
                MessageType requestedSchemaByUser = DataWritableReadSupport.getProjectedSchema(tableSchema, columnNamesList, indexColumnsWanted, groupPaths);
                return new ReadSupport.ReadContext(requestedSchemaByUser, contextMetadata);
            }
            return new ReadSupport.ReadContext(tableSchema, contextMetadata);
        }
        contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, fileSchema.toString());
        return new ReadSupport.ReadContext(fileSchema, contextMetadata);
    }

    @Override
    public RecordMaterializer<ArrayWritable> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map<String, String> metadata = readContext.getReadSupportMetadata();
        if (metadata == null) {
            throw new IllegalStateException("ReadContext not initialized properly. Don't know the Hive Schema.");
        }
        String key = HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname;
        if (!metadata.containsKey(key)) {
            metadata.put(key, String.valueOf(HiveConf.getBoolVar(configuration, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)));
        }
        return new DataWritableRecordConverter(readContext.getRequestedSchema(), metadata, this.hiveTypeInfo);
    }
}

