/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColAndCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterColAndScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterScalarAndColumn;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="and", value="a _FUNC_ b - Logical and")
@VectorizedExpressions(value={ColAndCol.class, FilterExprAndExpr.class, FilterColAndScalar.class, FilterScalarAndColumn.class})
public class GenericUDFOPAnd
extends GenericUDF {
    private final BooleanWritable result = new BooleanWritable();
    private transient BooleanObjectInspector boi0;
    private transient BooleanObjectInspector boi1;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The operator 'AND' only accepts 2 argument.");
        }
        this.boi0 = (BooleanObjectInspector)arguments[0];
        this.boi1 = (BooleanObjectInspector)arguments[1];
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        boolean bool_a0 = false;
        boolean bool_a1 = false;
        Object a0 = arguments[0].get();
        if (a0 != null && !(bool_a0 = this.boi0.get(a0))) {
            this.result.set(false);
            return this.result;
        }
        Object a1 = arguments[1].get();
        if (a1 != null && !(bool_a1 = this.boi1.get(a1))) {
            this.result.set(false);
            return this.result;
        }
        if (a0 != null && bool_a0 && a1 != null && bool_a1) {
            this.result.set(true);
            return this.result;
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "(" + children[0] + " and " + children[1] + ")";
    }

    @Override
    public GenericUDF negative() {
        return new GenericUDFOPOr();
    }
}

