/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;

public class HivePreFilteringRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog((String)HivePreFilteringRule.class.getName());
    public static final HivePreFilteringRule INSTANCE = new HivePreFilteringRule();
    private final RelFactories.FilterFactory filterFactory = HiveFilter.DEFAULT_FILTER_FACTORY;
    private static final Set<String> COMPARISON_UDFS = Sets.newHashSet(GenericUDFOPEqual.class.getAnnotation(Description.class).name(), GenericUDFOPEqualNS.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPNotEqual.class.getAnnotation(Description.class).name());
    private static final String IN_UDF = GenericUDFIn.class.getAnnotation(Description.class).name();
    private static final String BETWEEN_UDF = GenericUDFBetween.class.getAnnotation(Description.class).name();

    private HivePreFilteringRule() {
        super(HivePreFilteringRule.operand(Filter.class, (RelOptRuleOperand)HivePreFilteringRule.operand(RelNode.class, (RelOptRuleOperandChildren)HivePreFilteringRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelNode filterChild = call.rel(1);
        if (filterChild instanceof TableScan) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition());
        List<Object> commonOperands = new ArrayList();
        switch (condition.getKind()) {
            case AND: {
                ImmutableList operands = RexUtil.flattenAnd((Iterable)((RexCall)condition).getOperands());
                for (Object operand : operands) {
                    if (operand.getKind() != SqlKind.OR) continue;
                    commonOperands.addAll(HivePreFilteringRule.extractCommonOperands(rexBuilder, (RexNode)operand));
                }
                break;
            }
            case OR: {
                commonOperands = HivePreFilteringRule.extractCommonOperands(rexBuilder, condition);
                break;
            }
            default: {
                return;
            }
        }
        if (commonOperands.isEmpty()) {
            return;
        }
        RelOptPredicateList predicates = RelMetadataQuery.getPulledUpPredicates((RelNode)filter);
        ArrayList<RexNode> newConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : commonOperands) {
            boolean found = false;
            for (RexNode conjunct : predicates.pulledUpPredicates) {
                if (!rexNode.toString().equals(conjunct.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newConjuncts.add(rexNode);
        }
        if (newConjuncts.isEmpty()) {
            return;
        }
        RexNode newCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)RexUtil.composeConjunction((RexBuilder)rexBuilder, newConjuncts, (boolean)false));
        RelNode relNode = this.filterFactory.createFilter(filterChild, newCondition);
        RelNode newTopFilter = this.filterFactory.createFilter(relNode, condition);
        call.transformTo(newTopFilter);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<RexNode> extractCommonOperands(RexBuilder rexBuilder, RexNode condition) {
        void var3_4;
        assert (condition.getKind() == SqlKind.OR);
        LinkedHashMultimap<String, RexCall> reductionCondition = LinkedHashMultimap.create();
        Object var3_3 = null;
        ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)condition).getOperands());
        for (int i = 0; i < operands.size(); ++i) {
            void var3_7;
            RexNode operand = (RexNode)operands.get(i);
            RexNode operandCNF = RexUtil.toCnf((RexBuilder)rexBuilder, (RexNode)operand);
            List conjunctions = RelOptUtil.conjunctions((RexNode)operandCNF);
            HashSet<String> refsInCurrentOperand = Sets.newHashSet();
            for (RexNode conjunction : conjunctions) {
                if (!(conjunction instanceof RexCall)) {
                    return new ArrayList<RexNode>();
                }
                RexCall conjCall = (RexCall)conjunction;
                RexNode ref = null;
                if (COMPARISON_UDFS.contains(conjCall.getOperator().getName())) {
                    if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                        ref = (RexNode)conjCall.operands.get(0);
                    } else {
                        if (!(conjCall.operands.get(1) instanceof RexInputRef) || !(conjCall.operands.get(0) instanceof RexLiteral)) return new ArrayList<RexNode>();
                        ref = (RexNode)conjCall.operands.get(1);
                    }
                } else if (conjCall.getOperator().getName().equals(IN_UDF)) {
                    ref = (RexNode)conjCall.operands.get(0);
                } else {
                    if (!conjCall.getOperator().getName().equals(BETWEEN_UDF)) return new ArrayList<RexNode>();
                    ref = (RexNode)conjCall.operands.get(1);
                }
                String stringRef = ref.toString();
                reductionCondition.put(stringRef, conjCall);
                refsInCurrentOperand.add(stringRef);
            }
            if (i == 0) {
                HashSet<String> hashSet = refsInCurrentOperand;
            } else {
                Sets.SetView setView = Sets.intersection(var3_4, refsInCurrentOperand);
            }
            if (!var3_7.isEmpty()) continue;
            return new ArrayList<RexNode>();
        }
        ArrayList<RexNode> commonOperands = new ArrayList<RexNode>();
        for (String ref : var3_4) {
            commonOperands.add(RexUtil.composeDisjunction((RexBuilder)rexBuilder, reductionCondition.get(ref), (boolean)false));
        }
        return commonOperands;
    }
}

