/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class VectorMapJoinFastStringCommon {
    private boolean isOuterJoin;
    private BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
    private DeserializeRead.ReadStringResults readStringResults;

    public void adaptPutRow(VectorMapJoinFastBytesHashTable hashTable, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        if (this.keyBinarySortableDeserializeRead.readCheckNull()) {
            if (this.isOuterJoin) {
                return;
            }
            throw new HiveException("Unexpected NULL in map join small table");
        }
        this.keyBinarySortableDeserializeRead.readString(this.readStringResults);
        hashTable.add(this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length, currentValue);
    }

    public VectorMapJoinFastStringCommon(boolean isOuterJoin) {
        this.isOuterJoin = isOuterJoin;
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{TypeInfoFactory.stringTypeInfo};
        this.keyBinarySortableDeserializeRead = new BinarySortableDeserializeRead(primitiveTypeInfos);
        this.readStringResults = this.keyBinarySortableDeserializeRead.createReadStringResults();
    }
}

