/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class ExprNodeEvaluator<T extends ExprNodeDesc> {
    protected final T expr;
    protected ObjectInspector outputOI;
    private transient int version = -1;
    private transient Object evaluation;

    public ExprNodeEvaluator(T expr) {
        this.expr = expr;
    }

    public T getExpr() {
        return this.expr;
    }

    public abstract ObjectInspector initialize(ObjectInspector var1) throws HiveException;

    public ObjectInspector getOutputOI() {
        if (this.outputOI == null) {
            throw new IllegalStateException("Evaluator is not initialized");
        }
        return this.outputOI;
    }

    public Object evaluate(Object row) throws HiveException {
        return this.evaluate(row, -1);
    }

    protected Object evaluate(Object row, int version) throws HiveException {
        if (version < 0 || version != this.version) {
            this.version = version;
            this.evaluation = this._evaluate(row, version);
            return this.evaluation;
        }
        return this.evaluation;
    }

    protected abstract Object _evaluate(Object var1, int var2) throws HiveException;

    public boolean isDeterministic() {
        return true;
    }

    public boolean isStateful() {
        return false;
    }

    public ExprNodeEvaluator[] getChildren() {
        return null;
    }

    public String toString() {
        return "ExprNodeEvaluator[" + this.expr + "]";
    }
}

