/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.DefaultStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.MigrationStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StoreFileTrackerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileTrackerFactory.class);
    public static final String TRACKER_IMPL = "hbase.store.file-tracker.impl";
    private static final Map<Class<? extends StoreFileTracker>, Trackers> CLASS_TO_ENUM = StoreFileTrackerFactory.reverse();

    private static Map<Class<? extends StoreFileTracker>, Trackers> reverse() {
        HashMap<Class<? extends StoreFileTracker>, Trackers> map = new HashMap<Class<? extends StoreFileTracker>, Trackers>();
        for (Trackers tracker : Trackers.values()) {
            map.put(tracker.clazz, tracker);
        }
        return Collections.unmodifiableMap(map);
    }

    private StoreFileTrackerFactory() {
    }

    public static String getStoreFileTrackerName(Configuration conf) {
        return conf.get(TRACKER_IMPL, Trackers.DEFAULT.name());
    }

    public static String getStoreFileTrackerName(Class<? extends StoreFileTracker> clazz) {
        Trackers name = CLASS_TO_ENUM.get(clazz);
        return name != null ? name.name() : clazz.getName();
    }

    public static Class<? extends StoreFileTracker> getTrackerClass(Configuration conf) {
        try {
            Trackers tracker = Trackers.valueOf(StoreFileTrackerFactory.getStoreFileTrackerName(conf).toUpperCase());
            return tracker.clazz;
        }
        catch (IllegalArgumentException e) {
            return conf.getClass(TRACKER_IMPL, Trackers.DEFAULT.clazz, StoreFileTracker.class);
        }
    }

    public static Class<? extends StoreFileTracker> getTrackerClass(String trackerNameOrClass) {
        try {
            Trackers tracker = Trackers.valueOf(trackerNameOrClass.toUpperCase());
            return tracker.clazz;
        }
        catch (IllegalArgumentException e) {
            try {
                return Class.forName(trackerNameOrClass).asSubclass(StoreFileTracker.class);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static StoreFileTracker create(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        Class<? extends StoreFileTracker> tracker = StoreFileTrackerFactory.getTrackerClass(conf);
        LOG.info("instantiating StoreFileTracker impl {}", (Object)tracker.getName());
        return (StoreFileTracker)ReflectionUtils.newInstance(tracker, (Object[])new Object[]{conf, isPrimaryReplica, ctx});
    }

    public static StoreFileTracker create(Configuration conf, TableDescriptor td, ColumnFamilyDescriptor cfd, HRegionFileSystem regionFs) {
        StoreContext ctx = StoreContext.getBuilder().withColumnFamilyDescriptor(cfd).withRegionFileSystem(regionFs).withFamilyStoreDirectoryPath(regionFs.getStoreDir(cfd.getNameAsString())).build();
        return StoreFileTrackerFactory.create(StoreFileTrackerFactory.mergeConfigurations(conf, td, cfd), true, ctx);
    }

    private static Configuration mergeConfigurations(Configuration global, TableDescriptor table, ColumnFamilyDescriptor family) {
        return StoreUtils.createStoreConfiguration(global, table, family);
    }

    static Class<? extends StoreFileTrackerBase> getStoreFileTrackerClassForMigration(Configuration conf, String configName) {
        String trackerName = (String)Preconditions.checkNotNull((Object)conf.get(configName), (String)"config %s is not set", (Object)configName);
        try {
            return Trackers.valueOf((String)trackerName.toUpperCase()).clazz.asSubclass(StoreFileTrackerBase.class);
        }
        catch (IllegalArgumentException e) {
            try {
                return Class.forName(trackerName).asSubclass(StoreFileTrackerBase.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
    }

    static StoreFileTrackerBase createForMigration(Configuration conf, String configName, boolean isPrimaryReplica, StoreContext ctx) {
        Class<? extends StoreFileTrackerBase> tracker = StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, configName);
        if (MigrationStoreFileTracker.class.isAssignableFrom(tracker)) {
            throw new IllegalArgumentException("Should not specify " + configName + " as " + (Object)((Object)Trackers.MIGRATION) + " because it can not be nested");
        }
        LOG.info("instantiating StoreFileTracker impl {} as {}", (Object)tracker.getName(), (Object)configName);
        return (StoreFileTrackerBase)ReflectionUtils.newInstance(tracker, (Object[])new Object[]{conf, isPrimaryReplica, ctx});
    }

    public static TableDescriptor updateWithTrackerConfigs(Configuration conf, TableDescriptor descriptor) {
        if (StringUtils.isEmpty((String)descriptor.getValue(TRACKER_IMPL))) {
            StoreFileTracker tracker = StoreFileTrackerFactory.create(conf, true, null);
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor);
            return tracker.updateWithTrackerConfigs(builder).build();
        }
        return descriptor;
    }

    public static boolean isMigration(Class<?> clazz) {
        return MigrationStoreFileTracker.class.isAssignableFrom(clazz);
    }

    public static enum Trackers {
        DEFAULT(DefaultStoreFileTracker.class),
        FILE(FileBasedStoreFileTracker.class),
        MIGRATION(MigrationStoreFileTracker.class);

        final Class<? extends StoreFileTracker> clazz;

        private Trackers(Class<? extends StoreFileTracker> clazz) {
            this.clazz = clazz;
        }
    }
}

