/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MonitoredTaskImpl
implements MonitoredTask {
    private long startTime;
    private long statusTime;
    private long stateTime;
    private long warnTime;
    private volatile String status;
    private volatile String description;
    protected volatile MonitoredTask.State state = MonitoredTask.State.RUNNING;
    private final ConcurrentLinkedQueue<MonitoredTask.StatusJournalEntry> journal;
    private static final Gson GSON = GsonUtil.createGson().create();

    public MonitoredTaskImpl(boolean enableJournal) {
        this.statusTime = this.startTime = EnvironmentEdgeManager.currentTime();
        this.stateTime = this.startTime;
        this.warnTime = this.startTime;
        this.journal = enableJournal ? new ConcurrentLinkedQueue() : null;
    }

    @Override
    public synchronized MonitoredTaskImpl clone() {
        try {
            return (MonitoredTaskImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public long getStatusTime() {
        return this.statusTime;
    }

    @Override
    public MonitoredTask.State getState() {
        return this.state;
    }

    @Override
    public long getStateTime() {
        return this.stateTime;
    }

    @Override
    public long getWarnTime() {
        return this.warnTime;
    }

    @Override
    public long getCompletionTimestamp() {
        if (this.state == MonitoredTask.State.COMPLETE || this.state == MonitoredTask.State.ABORTED) {
            return this.stateTime;
        }
        return -1L;
    }

    @Override
    public void markComplete(String status) {
        this.setState(MonitoredTask.State.COMPLETE);
        this.setStatus(status);
    }

    @Override
    public void pause(String msg) {
        this.setState(MonitoredTask.State.WAITING);
        this.setStatus(msg);
    }

    @Override
    public void resume(String msg) {
        this.setState(MonitoredTask.State.RUNNING);
        this.setStatus(msg);
    }

    @Override
    public void abort(String msg) {
        this.setStatus(msg);
        this.setState(MonitoredTask.State.ABORTED);
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
        this.statusTime = EnvironmentEdgeManager.currentTime();
        if (this.journal != null) {
            this.journal.add(new StatusJournalEntryImpl(this.status, this.statusTime));
        }
    }

    protected void setState(MonitoredTask.State state) {
        this.state = state;
        this.stateTime = EnvironmentEdgeManager.currentTime();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setWarnTime(long t) {
        this.warnTime = t;
    }

    @Override
    public void cleanup() {
        if (this.state == MonitoredTask.State.RUNNING) {
            this.setState(MonitoredTask.State.ABORTED);
        }
    }

    @Override
    public void expireNow() {
        this.stateTime -= 180000L;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", this.getDescription());
        map.put("status", this.getStatus());
        map.put("state", (Object)this.getState());
        map.put("starttimems", this.getStartTime());
        map.put("statustimems", this.getCompletionTimestamp());
        map.put("statetimems", this.getCompletionTimestamp());
        return map;
    }

    @Override
    public String toJSON() throws IOException {
        return GSON.toJson(this.toMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getDescription());
        sb.append(": status=");
        sb.append(this.getStatus());
        sb.append(", state=");
        sb.append((Object)this.getState());
        sb.append(", startTime=");
        sb.append(this.getStartTime());
        sb.append(", completionTime=");
        sb.append(this.getCompletionTimestamp());
        return sb.toString();
    }

    @Override
    public List<MonitoredTask.StatusJournalEntry> getStatusJournal() {
        if (this.journal == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.journal);
    }

    @Override
    public String prettyPrintJournal() {
        if (this.journal == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<MonitoredTask.StatusJournalEntry> iter = this.journal.iterator();
        MonitoredTask.StatusJournalEntry previousEntry = null;
        while (iter.hasNext()) {
            long delta;
            MonitoredTask.StatusJournalEntry entry = iter.next();
            sb.append(entry);
            if (previousEntry != null && (delta = entry.getTimeStamp() - previousEntry.getTimeStamp()) != 0L) {
                sb.append(" (+" + delta + " ms)");
            }
            previousEntry = entry;
        }
        return sb.toString();
    }

    private static final class StatusJournalEntryImpl
    implements MonitoredTask.StatusJournalEntry {
        private final long statusTime;
        private final String status;

        public StatusJournalEntryImpl(String status, long statusTime) {
            this.status = status;
            this.statusTime = statusTime;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public long getTimeStamp() {
            return this.statusTime;
        }

        public String toString() {
            return this.status + " at " + this.statusTime;
        }
    }
}

