/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NamedQueuePayload {
    private final NamedQueueEvent namedQueueEvent;

    public NamedQueuePayload(int eventOrdinal) {
        this.namedQueueEvent = NamedQueueEvent.getEventByOrdinal(eventOrdinal);
    }

    public NamedQueueEvent getNamedQueueEvent() {
        return this.namedQueueEvent;
    }

    public static enum NamedQueueEvent {
        SLOW_LOG(0),
        BALANCE_DECISION(1);

        private final int value;

        private NamedQueueEvent(int i) {
            this.value = i;
        }

        public static NamedQueueEvent getEventByOrdinal(int value) {
            switch (value) {
                case 0: {
                    return SLOW_LOG;
                }
                case 1: {
                    return BALANCE_DECISION;
                }
            }
            throw new IllegalArgumentException("NamedQueue event with ordinal " + value + " not defined");
        }

        public int getValue() {
            return this.value;
        }
    }
}

