/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestFSHLog
extends AbstractTestFSWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSHLog.class);
    @Rule
    public TestName name = new TestName();

    @Override
    protected AbstractFSWAL<?> newWAL(FileSystem fs, Path rootDir, String walDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
        FSHLog fshLog = new FSHLog(fs, rootDir, walDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
        fshLog.init();
        return fshLog;
    }

    @Override
    protected AbstractFSWAL<?> newSlowWAL(FileSystem fs, Path rootDir, String walDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, final Runnable action) throws IOException {
        FSHLog fshLog = new FSHLog(fs, rootDir, walDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix){

            protected void atHeadOfRingBufferEventHandlerAppend() {
                action.run();
                super.atHeadOfRingBufferEventHandlerAppend();
            }
        };
        fshLog.init();
        return fshLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncRunnerIndexOverflow() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String name = this.name.getMethodName();
        log.init();
        try (FSHLog log = new FSHLog(FS, CommonFSUtils.getRootDir((Configuration)CONF), name, "oldWALs", CONF, null, true, null, null);){
            Field ringBufferEventHandlerField = FSHLog.class.getDeclaredField("ringBufferEventHandler");
            ringBufferEventHandlerField.setAccessible(true);
            FSHLog.RingBufferEventHandler ringBufferEventHandler = (FSHLog.RingBufferEventHandler)ringBufferEventHandlerField.get(log);
            Field syncRunnerIndexField = FSHLog.RingBufferEventHandler.class.getDeclaredField("syncRunnerIndex");
            syncRunnerIndexField.setAccessible(true);
            syncRunnerIndexField.set(ringBufferEventHandler, 0x7FFFFFFE);
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"row")).build();
            TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (byte[] fam : htd.getColumnFamilyNames()) {
                scopes.put(fam, 0);
            }
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
            MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
            for (int i = 0; i < 10; ++i) {
                this.addEdits((WAL)log, hri, htd, 1, mvcc, scopes);
            }
        }
    }

    @Test
    public void testUnflushedSeqIdTracking() throws IOException, InterruptedException {
        String name = this.name.getMethodName();
        final byte[] b = Bytes.toBytes((String)"b");
        final AtomicBoolean startHoldingForAppend = new AtomicBoolean(false);
        final CountDownLatch holdAppend = new CountDownLatch(1);
        final CountDownLatch flushFinished = new CountDownLatch(1);
        final CountDownLatch putFinished = new CountDownLatch(1);
        try (FSHLog log = new FSHLog(FS, CommonFSUtils.getRootDir((Configuration)CONF), name, "oldWALs", CONF, null, true, null, null);){
            log.init();
            log.registerWALActionsListener(new WALActionsListener(){

                public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
                    if (startHoldingForAppend.get()) {
                        try {
                            holdAppend.await();
                        }
                        catch (InterruptedException e) {
                            AbstractTestFSWAL.LOG.error(e.toString(), (Throwable)e);
                        }
                    }
                }
            });
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])b)).build();
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
            ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
            final HRegion region = TEST_UTIL.createLocalHRegion(hri, htd, (WAL)log);
            ExecutorService exec = Executors.newFixedThreadPool(2);
            region.put(new Put(b).addColumn(b, b, b));
            startHoldingForAppend.set(true);
            exec.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        region.put(new Put(b).addColumn(b, b, b));
                        putFinished.countDown();
                    }
                    catch (IOException e) {
                        AbstractTestFSWAL.LOG.error(e.toString(), (Throwable)e);
                    }
                }
            });
            Threads.sleep((long)3000L);
            exec.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        HRegion.FlushResult flushResult = region.flush(true);
                        AbstractTestFSWAL.LOG.info("Flush result:" + flushResult.getResult());
                        AbstractTestFSWAL.LOG.info("Flush succeeded:" + flushResult.isFlushSucceeded());
                        flushFinished.countDown();
                    }
                    catch (IOException e) {
                        AbstractTestFSWAL.LOG.error(e.toString(), (Throwable)e);
                    }
                }
            });
            Threads.sleep((long)3000L);
            holdAppend.countDown();
            putFinished.await();
            flushFinished.await();
            Assert.assertEquals((String)"Region did not flush?", (long)1L, (long)region.getStoreFileList((byte[][])new byte[][]{b}).size());
            long seqId = log.getEarliestMemStoreSeqNum(hri.getEncodedNameAsBytes());
            Assert.assertEquals((String)"Found seqId for the region which is already flushed", (long)-1L, (long)seqId);
            region.close();
        }
    }
}

