/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanException.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"scan");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] QUAL = Bytes.toBytes((String)"qual");
    private static AsyncConnection CONN;
    private static AtomicInteger REQ_COUNT;
    private static volatile int ERROR_AT;
    private static volatile boolean ERROR;
    private static volatile boolean DO_NOT_RETRY;
    private static final int ROW_COUNT = 100;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(ErrorCP.class.getName()).build());
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.toBytes((int)i)));
            }
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() {
        REQ_COUNT.set(0);
        ERROR_AT = 0;
        ERROR = false;
        DO_NOT_RETRY = false;
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testDoNotRetryIOException() throws IOException {
        ERROR_AT = 1;
        DO_NOT_RETRY = true;
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(FAMILY);){
            scanner.next();
        }
    }

    @Test
    public void testIOException() throws IOException {
        ERROR = true;
        try (ResultScanner scanner = CONN.getTableBuilder(TABLE_NAME).setMaxAttempts(3).build().getScanner(FAMILY);){
            scanner.next();
            Assert.fail();
        }
        catch (RetriesExhaustedException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ScannerResetException.class));
        }
        Assert.assertTrue((REQ_COUNT.get() >= 3 ? 1 : 0) != 0);
    }

    private void count() throws IOException {
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(new Scan().setCaching(1));){
            for (int i = 0; i < 100; ++i) {
                Result result = scanner.next();
                Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getRow());
                Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getValue(FAMILY, QUAL));
            }
        }
    }

    @Test
    public void testRecoveryFromScannerResetWhileOpening() throws IOException {
        ERROR_AT = 1;
        this.count();
        Assert.assertTrue((REQ_COUNT.get() >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoveryFromScannerResetInTheMiddle() throws IOException {
        ERROR_AT = 2;
        this.count();
        Assert.assertTrue((REQ_COUNT.get() >= 3 ? 1 : 0) != 0);
    }

    static {
        REQ_COUNT = new AtomicInteger();
    }

    public static final class ErrorCP
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
            REQ_COUNT.incrementAndGet();
            if (ERROR_AT == REQ_COUNT.get() || ERROR) {
                if (DO_NOT_RETRY) {
                    throw new DoNotRetryIOException("Injected exception");
                }
                throw new IOException("Injected exception");
            }
            return super.postScannerNext(c, s, result, limit, hasNext);
        }
    }
}

