/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestUpdateConfiguration;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestAsyncAdminBase
extends AbstractTestUpdateConfiguration {
    protected static final Logger LOG = LoggerFactory.getLogger(TestAsyncAdminBase.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static final byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
    protected static final byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");
    protected static AsyncConnection ASYNC_CONN;
    protected AsyncAdmin admin;
    @Parameterized.Parameter
    public Supplier<AsyncAdmin> getAdmin;
    @Rule
    public TestName testName = new TestName();
    protected TableName tableName;

    private static AsyncAdmin getRawAsyncAdmin() {
        return ASYNC_CONN.getAdmin();
    }

    private static AsyncAdmin getAsyncAdmin() {
        return ASYNC_CONN.getAdmin((ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({TestAsyncAdminBase::getRawAsyncAdmin}, {TestAsyncAdminBase::getAsyncAdmin});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).numMasters(2).build();
        TEST_UTIL.startMiniCluster(option);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = this.getAdmin.get();
        String methodName = this.testName.getMethodName();
        this.tableName = TableName.valueOf((String)methodName.substring(0, methodName.length() - 3));
    }

    @After
    public void tearDown() throws Exception {
        ((CompletableFuture)this.admin.listTableNames(Pattern.compile(this.tableName.getNameAsString() + ".*"), false).whenCompleteAsync((tables, err) -> {
            if (tables != null) {
                tables.forEach(table -> {
                    try {
                        this.admin.disableTable(table).join();
                    }
                    catch (Exception e) {
                        LOG.debug("Table: " + this.tableName + " already disabled, so just deleting it.");
                    }
                    this.admin.deleteTable(table).join();
                });
            }
        }, (Executor)ForkJoinPool.commonPool())).join();
        if (!((Boolean)this.admin.isBalancerEnabled().join()).booleanValue()) {
            this.admin.balancerSwitch(true, true);
        }
    }

    protected void createTableWithDefaultConf(TableName tableName) throws IOException {
        this.createTableWithDefaultConf(tableName, null);
    }

    protected void createTableWithDefaultConf(TableName tableName, int regionReplication) throws IOException {
        this.createTableWithDefaultConf(tableName, regionReplication, (byte[][])null, (byte[][])new byte[][]{FAMILY});
    }

    protected void createTableWithDefaultConf(TableName tableName, byte[][] splitKeys) throws IOException {
        this.createTableWithDefaultConf(tableName, splitKeys, (byte[][])new byte[][]{FAMILY});
    }

    protected void createTableWithDefaultConf(TableName tableName, int regionReplication, byte[][] splitKeys) throws IOException {
        this.createTableWithDefaultConf(tableName, regionReplication, splitKeys, (byte[][])new byte[][]{FAMILY});
    }

    protected void createTableWithDefaultConf(TableName tableName, byte[][] splitKeys, byte[] ... families) throws IOException {
        this.createTableWithDefaultConf(tableName, 1, splitKeys, families);
    }

    protected void createTableWithDefaultConf(TableName tableName, int regionReplication, byte[][] splitKeys, byte[] ... families) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(regionReplication);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        CompletableFuture future = splitKeys == null ? this.admin.createTable(builder.build()) : this.admin.createTable(builder.build(), splitKeys);
        future.join();
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
    }
}

