/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAdminBase;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAdmin1
extends TestAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin1.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAdmin1.class);

    @Test
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        TableName unknowntable = TableName.valueOf((String)this.name.getMethodName());
        IOException exception = null;
        try {
            ADMIN.compact(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.flush(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.split(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    @Test
    public void testCompactionTimestamps() throws Exception {
        byte[] regionName;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam1")).build();
        ADMIN.createTable(htd);
        Table table = TEST_UTIL.getConnection().getTable(htd.getTableName());
        long ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        ADMIN.flush(tableName);
        ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            regionName = ((HRegionLocation)l.getAllRegionLocations().get(0)).getRegion().getRegionName();
        }
        long ts1 = ADMIN.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        ADMIN.flush(tableName);
        ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts1, (long)ts);
        TEST_UTIL.compact(tableName, true);
        table.put(p);
        ADMIN.flush(tableName);
        ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertTrue((ts > ts1 ? 1 : 0) != 0);
        ts1 = ADMIN.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.put(p);
        ADMIN.flush(tableName);
        ts = ADMIN.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testColumnValidName() {
        ColumnFamilyDescriptorBuilder.of((String)"\\test\\abc");
    }

    @Test
    public void testTableExist() throws IOException {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        boolean exist = ADMIN.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = ADMIN.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = 1;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        byte[] splitKey = Bytes.toBytes((int)3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize, true);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize, false);
    }

    @Test
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = 1;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
    }

    private int count(ResultScanner scanner) throws IOException {
        int rows = 0;
        while (scanner.next() != null) {
            ++rows;
        }
        return rows;
    }

    private void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize, boolean async) throws Exception {
        TableName tableName = TableName.valueOf((String)"testForceSplit");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCounts.length; ++i) {
            sb.append("_").append(Integer.toString(rowCounts[i]));
        }
        Assert.assertFalse((boolean)ADMIN.tableExists(tableName));
        try (Table table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
             final RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            int rows;
            Object put;
            int rowCount = 0;
            byte[] q = new byte[]{};
            for (int index = 0; index < familyNames.length; ++index) {
                ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
                for (int i = 0; i < rowCounts[index]; ++i) {
                    byte[] k = Bytes.toBytes((int)i);
                    put = new Put(k);
                    put.addColumn(familyNames[index], q, k);
                    puts.add((Put)put);
                }
                table.put(puts);
                if (rowCount >= rowCounts[index]) continue;
                rowCount = rowCounts[index];
            }
            List m = locator.getAllRegionLocations();
            LOG.info("Initial regions (" + m.size() + "): " + m);
            Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
            Scan scan = new Scan();
            ResultScanner scanner = table.getScanner(scan);
            put = null;
            try {
                rows = this.count(scanner);
            }
            catch (Throwable throwable) {
                put = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (put != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)put).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Assert.assertEquals((long)rowCount, (long)rows);
            scan = new Scan();
            scanner = table.getScanner(scan);
            put = null;
            try {
                scanner.next();
                if (async) {
                    ADMIN.split(tableName, splitPoint);
                    final AtomicInteger count = new AtomicInteger(0);
                    Thread t = new Thread("CheckForSplit"){

                        @Override
                        public void run() {
                            for (int i = 0; i < 45; ++i) {
                                try {
                                    1.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    continue;
                                }
                                List regions = null;
                                try {
                                    regions = locator.getAllRegionLocations();
                                }
                                catch (IOException e) {
                                    LOG.warn("get location failed", (Throwable)e);
                                }
                                if (regions == null) continue;
                                count.set(regions.size());
                                if (count.get() >= 2) {
                                    LOG.info("Found: " + regions);
                                    break;
                                }
                                LOG.debug("Cycle waiting on split");
                            }
                            LOG.debug("CheckForSplit thread exited, current region count: " + count.get());
                        }
                    };
                    t.setPriority(3);
                    t.start();
                    t.join();
                } else {
                    ADMIN.splitRegionAsync(((HRegionLocation)m.get(0)).getRegion().getRegionName(), splitPoint).get();
                }
                rows = 1 + this.count(scanner);
            }
            catch (Throwable count) {
                put = count;
                throw count;
            }
            finally {
                if (scanner != null) {
                    if (put != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable count) {
                            ((Throwable)put).addSuppressed(count);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Assert.assertEquals((long)rowCount, (long)rows);
            List regions = null;
            try {
                regions = locator.getAllRegionLocations();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Assert.assertEquals((long)2L, (long)regions.size());
            if (splitPoint != null) {
                Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])((HRegionLocation)regions.get(0)).getRegion().getEndKey()));
                Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])((HRegionLocation)regions.get(1)).getRegion().getStartKey()));
                LOG.debug("Properly split on " + Bytes.toString((byte[])splitPoint));
            } else if (familyNames.length > 1) {
                int splitKey = Bytes.toInt((byte[])((HRegionLocation)regions.get(0)).getRegion().getEndKey());
                int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
                LOG.debug("SplitKey=" + splitKey + "&deltaForLargestFamily=" + deltaForLargestFamily + ", r=" + ((HRegionLocation)regions.get(0)).getRegion());
                for (int index = 0; index < familyNames.length; ++index) {
                    int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                    if (delta >= deltaForLargestFamily) continue;
                    Assert.assertTrue((String)("Delta " + delta + " for family " + index + " should be at least deltaForLargestFamily " + deltaForLargestFamily), (boolean)false);
                }
            }
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testSplitAndMergeWithReplicaTable() throws Exception {
        List<HRegion> oldRegions;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = Bytes.toBytes((String)"f");
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf)).build();
        byte[][] splitRows = new byte[][]{{52}, {55}};
        TEST_UTIL.getAdmin().createTable(desc, (byte[][])splitRows);
        do {
            oldRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            Thread.sleep(10L);
        } while (oldRegions.size() != 9);
        Table ht = TEST_UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        byte[] qualifier = Bytes.toBytes((String)"c");
        Put put = new Put(new byte[]{49});
        put.addColumn(cf, qualifier, Bytes.toBytes((String)"100"));
        puts.add(put);
        put = new Put(new byte[]{54});
        put.addColumn(cf, qualifier, Bytes.toBytes((String)"100"));
        puts.add(put);
        put = new Put(new byte[]{56});
        put.addColumn(cf, qualifier, Bytes.toBytes((String)"100"));
        puts.add(put);
        ht.put(puts);
        ht.close();
        List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        boolean gotException = false;
        try {
            TEST_UTIL.getAdmin().splitRegionAsync(((RegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName()).get();
        }
        catch (IllegalArgumentException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().splitRegionAsync((RegionInfo)((Pair)regions.get(1)).getFirst(), new byte[]{49});
        }
        catch (IOException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getAdmin().splitRegionAsync(((RegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName(), new byte[]{49}).get();
        }
        catch (IllegalArgumentException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getAdmin().mergeRegionsAsync(((RegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), ((RegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes(), true).get();
        }
        catch (IllegalArgumentException m) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        try {
            byte[][] nameofRegionsToMerge = new byte[][]{((RegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), ((RegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes()};
            MasterProtos.MergeTableRegionsRequest request = RequestConverter.buildMergeTableRegionsRequest((byte[][])nameofRegionsToMerge, (boolean)true, (long)0L, (long)0L);
            ((ClusterConnection)TEST_UTIL.getAdmin().getConnection()).getMaster().mergeTableRegions(null, request);
        }
        catch (ServiceException m) {
            Throwable t = m.getCause();
            do {
                if (!(t instanceof MergeRegionException)) continue;
                gotException = true;
                break;
            } while ((t = t.getCause()) != null);
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidColumnDescriptor() throws IOException {
        ColumnFamilyDescriptorBuilder.of((String)"/cfamily/name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHFileReplication() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String fn1 = "rep1";
        String fn = "defaultRep";
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)fn)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)fn1)).setDFSReplication((short)1).build()).build();
        Table table = TEST_UTIL.createTable(htd, (byte[][])null);
        TEST_UTIL.waitTableAvailable(tableName);
        Put p = new Put(Bytes.toBytes((String)"defaultRep_rk"));
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] v1 = Bytes.toBytes((String)"v1");
        p.addColumn(Bytes.toBytes((String)fn), q1, v1);
        ArrayList<Put> puts = new ArrayList<Put>(2);
        puts.add(p);
        p = new Put(Bytes.toBytes((String)"rep1_rk"));
        p.addColumn(Bytes.toBytes((String)fn1), q1, v1);
        puts.add(p);
        try {
            table.put(puts);
            ADMIN.flush(tableName);
            List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(tableName);
            for (HRegion r : regions) {
                HStore store = r.getStore(Bytes.toBytes((String)fn));
                for (HStoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn));
                    Assert.assertTrue((String)("Column family " + fn + " should have 3 copies"), (CommonFSUtils.getDefaultReplication((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)sf.getPath()) == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
                store = r.getStore(Bytes.toBytes((String)fn1));
                for (HStoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn1));
                    Assert.assertTrue((String)("Column family " + fn1 + " should have only 1 copy"), (1 == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (ADMIN.isTableEnabled(tableName)) {
                ADMIN.disableTable(tableName);
                ADMIN.deleteTable(tableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"d")).build();
        byte[][] splitRows = new byte[][]{{51}, {54}};
        try {
            TEST_UTIL.createTable(td, (byte[][])splitRows);
            TEST_UTIL.waitTableAvailable(tableName);
            RegionInfo mergedChildRegion = null;
            List tableRegions = ADMIN.getRegions(tableName);
            Assert.assertEquals((long)3L, (long)tableRegions.size());
            RegionInfo regionA = (RegionInfo)tableRegions.get(0);
            RegionInfo regionB = (RegionInfo)tableRegions.get(1);
            RegionInfo regionC = (RegionInfo)tableRegions.get(2);
            ADMIN.mergeRegionsAsync(regionA.getRegionName(), regionB.getRegionName(), false).get(60L, TimeUnit.SECONDS);
            tableRegions = ADMIN.getRegions(tableName);
            Assert.assertEquals((long)2L, (long)tableRegions.size());
            for (RegionInfo ri : tableRegions) {
                if (regionC.compareTo(ri) == 0) continue;
                mergedChildRegion = ri;
                break;
            }
            Assert.assertNotNull(mergedChildRegion);
            HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
            CatalogJanitor cj = services.getCatalogJanitor();
            Assert.assertTrue((cj.scan() > 0 ? 1 : 0) != 0);
            while (!services.getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
                Thread.sleep(200L);
            }
            ADMIN.mergeRegionsAsync(regionC.getEncodedNameAsBytes(), mergedChildRegion.getEncodedNameAsBytes(), false).get(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)ADMIN.getRegions(tableName).size());
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRegionsInvalidRegionCount() throws IOException, InterruptedException, ExecutionException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"d")).build();
        byte[][] splitRows = new byte[][]{{51}, {54}};
        try {
            TEST_UTIL.createTable(td, (byte[][])splitRows);
            TEST_UTIL.waitTableAvailable(tableName);
            List tableRegions = ADMIN.getRegions(tableName);
            try {
                ADMIN.mergeRegionsAsync(new byte[0][0], false).get();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                ADMIN.mergeRegionsAsync((byte[][])new byte[][]{((RegionInfo)tableRegions.get(0)).getEncodedNameAsBytes()}, false).get();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }

    @Test
    public void testSplitShouldNotHappenIfSplitIsDisabledForTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        Table table = TEST_UTIL.createTable(htd, (byte[][])null);
        for (int i = 0; i < 10; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            byte[] q1 = Bytes.toBytes((String)"q1");
            byte[] v1 = Bytes.toBytes((String)"v1");
            p.addColumn(Bytes.toBytes((String)"f"), q1, v1);
            table.put(p);
        }
        ADMIN.flush(tableName);
        try {
            ADMIN.split(tableName, Bytes.toBytes((String)"row5"));
            Threads.sleep((long)10000L);
        }
        catch (Exception i) {
            // empty catch block
        }
        List allRegions = MetaTableAccessor.getTableRegions((Connection)ADMIN.getConnection(), (TableName)tableName, (boolean)true);
        Assert.assertEquals((long)1L, (long)allRegions.size());
    }
}

