// Autogenerated Jamon implementation
// /home/vjasani/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/AssignmentManagerStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 20, 1
import java.util.Map;
// 21, 1
import java.util.Set;
// 22, 1
import java.util.SortedSet;
// 23, 1
import java.util.concurrent.atomic.AtomicInteger;
// 24, 1
import java.util.stream.Collectors;
// 25, 1
import org.apache.hadoop.conf.Configuration;
// 26, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 27, 1
import org.apache.hadoop.hbase.HConstants;
// 28, 1
import org.apache.hadoop.hbase.ServerName;
// 29, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 30, 1
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
// 31, 1
import org.apache.hadoop.hbase.master.RegionState;
// 32, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 33, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager.RegionInTransitionStat;
// 34, 1
import org.apache.hadoop.hbase.master.assignment.RegionStates.RegionFailedOpen;
// 35, 1
import org.apache.hadoop.hbase.util.Pair;

public class AssignmentManagerStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.Intf

{
  private final AssignmentManager assignmentManager;
  private final int limit;
  protected static org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getLimit__IsNotDefault())
    {
      p_implData.setLimit(100);
    }
    return p_implData;
  }
  public AssignmentManagerStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    assignmentManager = p_implData.getAssignmentManager();
    limit = p_implData.getLimit();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 42, 1
    
SortedSet<RegionState> rit = assignmentManager.getRegionStates()
    .getRegionsInTransitionOrderedByTimestamp();

    // 47, 1
    if (!rit.isEmpty() )
    {
      // 47, 23
      jamonWriter.write("\n");
      // 48, 1
      
long currentTime = System.currentTimeMillis();
RegionInTransitionStat ritStat = assignmentManager.computeRegionInTransitionStat();

int numOfRITs = rit.size();
int ritsPerPage = Math.min(5, numOfRITs);
int numOfPages = (int) Math.ceil(numOfRITs * 1.0 / ritsPerPage);

      // 56, 5
      jamonWriter.write("<section>\n    <h2><a name=\"rit\">Regions in Transition</a></h2>\n     <p><a href=\"/rits.jsp\">");
      // 58, 29
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITs), jamonWriter);
      // 58, 44
      jamonWriter.write(" region(s) in transition.</a>\n     ");
      // 59, 6
      if (ritStat.hasRegionsTwiceOverThreshold()  )
      {
        // 59, 53
        jamonWriter.write("\n         <span class=\"label label-danger\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 61, 6
      else if (ritStat.hasRegionsOverThreshold() )
      {
        // 61, 51
        jamonWriter.write("\n         <span class=\"label label-warning\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 63, 6
      else
      {
        // 63, 13
        jamonWriter.write("\n         <span>\n     ");
      }
      // 65, 12
      jamonWriter.write("\n         ");
      // 66, 10
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritStat.getTotalRITsOverThreshold()), jamonWriter);
      // 66, 51
      jamonWriter.write(" region(s) in transition for\n             more than ");
      // 67, 24
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritStat.getRITThreshold()), jamonWriter);
      // 67, 55
      jamonWriter.write(" milliseconds.\n         </span>\n     </p>\n     <div class=\"tabbable\">\n         <div class=\"tab-content\">\n         ");
      // 72, 10
      int recordItr = 0; 
      // 73, 10
      for (RegionState rs : rit )
      {
        // 73, 39
        jamonWriter.write("\n             ");
        // 74, 14
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 74, 52
          jamonWriter.write("\n                 ");
          // 75, 18
          if (recordItr == 0 )
          {
            // 75, 40
            jamonWriter.write("\n             <div class=\"tab-pane active\" id=\"tab_rits");
            // 76, 55
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 76, 90
            jamonWriter.write("\">\n                 ");
          }
          // 77, 18
          else
          {
            // 77, 25
            jamonWriter.write("\n             <div class=\"tab-pane\" id=\"tab_rits");
            // 78, 48
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 78, 83
            jamonWriter.write("\">\n                 ");
          }
          // 79, 24
          jamonWriter.write("\n                 <table class=\"table table-striped\" style=\"margin-bottom:0px;\"><tr><th>Region</th>\n                     <th>State</th><th>RIT time (ms)</th> <th>Retries </th></tr>\n             ");
        }
        // 82, 20
        jamonWriter.write("\n\n             ");
        // 84, 14
        if (ritStat.isRegionTwiceOverThreshold(rs.getRegion()) )
        {
          // 84, 72
          jamonWriter.write("\n                     <tr class=\"alert alert-danger\" role=\"alert\">\n             ");
        }
        // 86, 14
        else if (ritStat.isRegionOverThreshold(rs.getRegion()) )
        {
          // 86, 71
          jamonWriter.write("\n                     <tr class=\"alert alert-warning\" role=\"alert\">\n            ");
        }
        // 88, 13
        else
        {
          // 88, 20
          jamonWriter.write("\n                    <tr>\n            ");
        }
        // 90, 19
        jamonWriter.write("\n                        ");
        // 91, 25
        
                          String retryStatus = "0";
                          RegionFailedOpen regionFailedOpen = assignmentManager
                            .getRegionStates().getFailedOpen(rs.getRegion());
                          if (regionFailedOpen != null) {
                            retryStatus = Integer.toString(regionFailedOpen.getRetries());
                          } else if (rs.getState() ==  RegionState.State.FAILED_OPEN) {
                            retryStatus = "Failed";
                          }
                        
        // 101, 25
        jamonWriter.write("<td>");
        // 101, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rs.getRegion().getEncodedName()), jamonWriter);
        // 101, 66
        jamonWriter.write("</td><td>\n                        ");
        // 102, 25
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay(rs,
                            assignmentManager.getConfiguration())), jamonWriter);
        // 103, 69
        jamonWriter.write("</td>\n                        <td>");
        // 104, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((currentTime - rs.getStamp())), jamonWriter);
        // 104, 64
        jamonWriter.write(" </td>\n                        <td> ");
        // 105, 30
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(retryStatus), jamonWriter);
        // 105, 47
        jamonWriter.write(" </td>\n                     </tr>\n                     ");
        // 107, 22
        recordItr++; 
        // 108, 14
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 108, 52
          jamonWriter.write("\n                 </table>\n             </div>\n         ");
        }
        // 111, 16
        jamonWriter.write("\n         ");
      }
      // 112, 17
      jamonWriter.write("\n\n         ");
      // 114, 10
      if ((recordItr % ritsPerPage) != 0 )
      {
        // 114, 48
        jamonWriter.write("\n             ");
        // 115, 14
        for (; (recordItr % ritsPerPage) != 0 ; recordItr++ )
        {
          // 115, 69
          jamonWriter.write("\n             <tr><td colspan=\"3\" style=\"height:61px\"></td></tr>\n             ");
        }
        // 117, 21
        jamonWriter.write("\n                   </table>\n             </div>\n         ");
      }
      // 120, 16
      jamonWriter.write("\n         </div>\n         <input type=\"hidden\" id =\"rit_page_num\" value=\"");
      // 122, 57
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITs), jamonWriter);
      // 122, 72
      jamonWriter.write("\" />\n         <input type=\"hidden\" id =\"rit_per_page\" value=\"");
      // 123, 57
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritsPerPage), jamonWriter);
      // 123, 74
      jamonWriter.write("\" />\n         <nav id=\"rit_pagination\"></nav>\n     </div>\n   </section>\n ");
    }
    // 127, 8
    jamonWriter.write("\n\n");
  }
  
  
}
