/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.BaseTimeToLiveFileCleaner;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class TimeToLiveHFileCleaner
extends BaseTimeToLiveFileCleaner {
    public static final String TTL_CONF_KEY = "hbase.master.hfilecleaner.ttl";
    public static final long DEFAULT_TTL = 300000L;

    @Override
    protected long getTtlMs(Configuration conf) {
        return conf.getLong(TTL_CONF_KEY, 300000L);
    }

    @Override
    protected boolean valiateFilename(Path file) {
        return HFileLink.isBackReferencesDir(file) || HFileLink.isBackReferencesDir(file.getParent()) || StoreFileInfo.validateStoreFileName(file.getName());
    }
}

