/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.DisabledWALProvider;
import org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
public class WALFactory {
    private static final Log LOG = LogFactory.getLog(WALFactory.class);
    public static final String WAL_PROVIDER = "hbase.wal.provider";
    static final String DEFAULT_WAL_PROVIDER = Providers.defaultProvider.name();
    static final String META_WAL_PROVIDER = "hbase.wal.meta_provider";
    static final String DEFAULT_META_WAL_PROVIDER = Providers.defaultProvider.name();
    final String factoryId;
    final WALProvider provider;
    final AtomicReference<WALProvider> metaProvider = new AtomicReference();
    private final Class<? extends DefaultWALProvider.Reader> logReaderClass;
    private final int timeoutMillis;
    private final Configuration conf;
    private static final AtomicReference<WALFactory> singleton = new AtomicReference();
    private static final String SINGLETON_ID = WALFactory.class.getName();

    private WALFactory(Configuration conf) {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, DefaultWALProvider.Reader.class);
        this.conf = conf;
        this.provider = null;
        this.factoryId = SINGLETON_ID;
    }

    Class<? extends WALProvider> getProviderClass(String key, String defaultValue) {
        try {
            return Providers.valueOf((String)this.conf.get((String)key, (String)defaultValue)).clazz;
        }
        catch (IllegalArgumentException exception) {
            return this.conf.getClass(key, DefaultWALProvider.class, WALProvider.class);
        }
    }

    WALProvider createProvider(Class<? extends WALProvider> clazz, List<WALActionsListener> listeners, String providerId) throws IOException {
        LOG.info((Object)("Instantiating WALProvider of type " + clazz));
        try {
            WALProvider result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.init(this, this.conf, listeners, providerId);
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("couldn't set up WALProvider, the configured class is " + clazz));
            LOG.debug((Object)"Exception details for failure to load WALProvider.", (Throwable)e);
            throw new IOException("couldn't set up WALProvider", e);
        }
    }

    WALProvider getProvider(String key, String defaultValue, List<WALActionsListener> listeners, String providerId) throws IOException {
        Class<? extends WALProvider> clazz = this.getProviderClass(key, defaultValue);
        return this.createProvider(clazz, listeners, providerId);
    }

    public WALFactory(Configuration conf, List<WALActionsListener> listeners, String factoryId) throws IOException {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, DefaultWALProvider.Reader.class);
        this.conf = conf;
        this.factoryId = factoryId;
        if (conf.getBoolean("hbase.regionserver.hlog.enabled", true)) {
            this.provider = this.getProvider(WAL_PROVIDER, DEFAULT_WAL_PROVIDER, listeners, null);
        } else {
            LOG.warn((Object)"Running with WAL disabled.");
            this.provider = new DisabledWALProvider();
            this.provider.init(this, conf, null, factoryId);
        }
    }

    public void close() throws IOException {
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            metaProvider.close();
        }
        if (null != this.provider) {
            this.provider.close();
        }
    }

    public void shutdown() throws IOException {
        IOException exception = null;
        WALProvider metaProvider = this.metaProvider.get();
        if (null != metaProvider) {
            try {
                metaProvider.shutdown();
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        this.provider.shutdown();
        if (null != exception) {
            throw exception;
        }
    }

    public List<WAL> getWALs() throws IOException {
        return this.provider.getWALs();
    }

    public WAL getWAL(byte[] identifier, byte[] namespace) throws IOException {
        return this.provider.getWAL(identifier, namespace);
    }

    public WAL getMetaWAL(byte[] identifier) throws IOException {
        WALProvider metaProvider = this.metaProvider.get();
        if (null == metaProvider) {
            WALProvider temp = this.getProvider(META_WAL_PROVIDER, DEFAULT_META_WAL_PROVIDER, Collections.singletonList(new MetricsWAL()), ".meta");
            if (this.metaProvider.compareAndSet(null, temp)) {
                metaProvider = temp;
            } else {
                temp.close();
                metaProvider = this.metaProvider.get();
            }
        }
        return metaProvider.getWAL(identifier, null);
    }

    public WAL.Reader createReader(FileSystem fs, Path path) throws IOException {
        return this.createReader(fs, path, null);
    }

    public WAL.Reader createReader(FileSystem fs, Path path, CancelableProgressable reporter) throws IOException {
        return this.createReader(fs, path, reporter, true);
    }

    /*
     * Exception decompiling
     */
    public WAL.Reader createReader(FileSystem fs, Path path, CancelableProgressable reporter, boolean allowCustom) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public WALProvider.Writer createWALWriter(FileSystem fs, Path path) throws IOException {
        return DefaultWALProvider.createWriter(this.conf, fs, path, false);
    }

    public WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path) throws IOException {
        return DefaultWALProvider.createWriter(this.conf, fs, path, true);
    }

    public static WALFactory getInstance(Configuration configuration) {
        WALFactory factory = singleton.get();
        if (null == factory) {
            WALFactory temp = new WALFactory(configuration);
            if (singleton.compareAndSet(null, temp)) {
                factory = temp;
            } else {
                try {
                    temp.close();
                }
                catch (IOException exception) {
                    LOG.debug((Object)"failed to close temporary singleton. ignoring.", (Throwable)exception);
                }
                factory = singleton.get();
            }
        }
        return factory;
    }

    public static WAL.Reader createReader(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path);
    }

    static WAL.Reader createReader(FileSystem fs, Path path, Configuration configuration, CancelableProgressable reporter) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path, reporter);
    }

    public static WAL.Reader createReaderIgnoreCustomClass(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return WALFactory.getInstance(configuration).createReader(fs, path, null, false);
    }

    static WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return DefaultWALProvider.createWriter(configuration, fs, path, true);
    }

    public static WALProvider.Writer createWALWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return DefaultWALProvider.createWriter(configuration, fs, path, false);
    }

    public final WALProvider getWALProvider() {
        return this.provider;
    }

    public final WALProvider getMetaWALProvider() {
        return this.metaProvider.get();
    }

    static enum Providers {
        defaultProvider(DefaultWALProvider.class),
        filesystem(DefaultWALProvider.class),
        multiwal(RegionGroupingProvider.class);

        final Class<? extends WALProvider> clazz;

        private Providers(Class<? extends WALProvider> clazz) {
            this.clazz = clazz;
        }
    }
}

