/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogTableOpsChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogTableOpsChore.class);
    private final NamedQueueRecorder namedQueueRecorder;

    public SlowLogTableOpsChore(Stoppable stopper, int period, NamedQueueRecorder namedQueueRecorder) {
        super("SlowLogTableOpsChore", stopper, period);
        this.namedQueueRecorder = namedQueueRecorder;
    }

    protected void chore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("SlowLog Table Ops Chore is starting up.");
        }
        this.namedQueueRecorder.persistAll(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
        if (LOG.isTraceEnabled()) {
            LOG.trace("SlowLog Table Ops Chore is closing.");
        }
    }
}

