/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;

@InterfaceAudience.Private
public interface SplitLogManagerCoordination {
    public void setDetails(SplitLogManagerDetails var1);

    public SplitLogManagerDetails getDetails();

    public String prepareTask(String var1);

    public void markRegionsRecovering(ServerName var1, Set<HRegionInfo> var2) throws IOException, InterruptedIOException;

    public void checkTasks();

    public void removeRecoveringRegions(Set<String> var1, Boolean var2) throws IOException;

    public int remainingTasksInCoordination();

    public void checkTaskStillAvailable(String var1);

    public void setRecoveryMode(boolean var1) throws InterruptedIOException, IOException;

    public void removeStaleRecoveringRegions(Set<String> var1) throws IOException, InterruptedIOException;

    public boolean resubmitTask(String var1, SplitLogManager.Task var2, SplitLogManager.ResubmitDirective var3);

    public void submitTask(String var1);

    public void deleteTask(String var1);

    public boolean isReplaying();

    public boolean isSplitting();

    public long getLastRecoveryTime();

    public ZooKeeperProtos.SplitLogTask.RecoveryMode getRecoveryMode();

    public void init() throws IOException;

    public static class SplitLogManagerDetails {
        private final ConcurrentMap<String, SplitLogManager.Task> tasks;
        private final MasterServices master;
        private final Set<String> failedDeletions;
        private final ServerName serverName;

        public SplitLogManagerDetails(ConcurrentMap<String, SplitLogManager.Task> tasks, MasterServices master, Set<String> failedDeletions, ServerName serverName) {
            this.tasks = tasks;
            this.master = master;
            this.failedDeletions = failedDeletions;
            this.serverName = serverName;
        }

        public MasterServices getMaster() {
            return this.master;
        }

        public ConcurrentMap<String, SplitLogManager.Task> getTasks() {
            return this.tasks;
        }

        public Set<String> getFailedDeletions() {
            return this.failedDeletions;
        }

        public ServerName getServerName() {
            return this.serverName;
        }
    }
}

