// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.ServerLoad;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 32, 9
import org.apache.hadoop.hbase.client.HConnectionManager;
// 33, 9
import org.apache.hadoop.hbase.HTableDescriptor;
// 34, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 36, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((servers != null && servers.size() > 0))
    {
      // 40, 47
      jamonWriter.write("\n\n");
      // 42, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 47, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 57, 13
      {
        // 57, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 57, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 60, 13
      {
        // 60, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 60, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 63, 13
      {
        // 63, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 63, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 66, 13
      {
        // 66, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 66, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 69, 13
      {
        // 69, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 69, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 74, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 181, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 185, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 192, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 198, 1
    jamonWriter.write("<tr>\n<td>");
    // 199, 5
    {
      // 199, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 199, 66
    jamonWriter.write("</td>\n<td>");
    // 200, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 200, 59
    jamonWriter.write("</td>\n<td>");
    // 201, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 201, 36
    jamonWriter.write("</td>\n<td>");
    // 202, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 202, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 204, 1
    
        }  else {
        
    // 207, 1
    {
      // 207, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 207, 40
    jamonWriter.write("\n");
    // 208, 1
    
        }
}

    // 212, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 319, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 323, 5
    jamonWriter.write("<tr>\n    <td>");
    // 324, 9
    {
      // 324, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 324, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 302, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerLoad serverLoad)
    throws java.io.IOException
  {
    // 307, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 312, 9
    if (infoPort > 0)
    {
      // 312, 28
      jamonWriter.write("\n            <a href=\"");
      // 313, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 313, 31
      jamonWriter.write("\">");
      // 313, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 313, 65
      jamonWriter.write("</a>\n        ");
    }
    // 314, 9
    else
    {
      // 314, 16
      jamonWriter.write("\n            ");
      // 315, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 315, 45
      jamonWriter.write("\n        ");
    }
    // 316, 15
    jamonWriter.write("\n");
  }
  
  
  // 141, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 145, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 153, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 159, 1
    jamonWriter.write("<tr>\n    <td>");
    // 160, 9
    {
      // 160, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 160, 70
    jamonWriter.write("</td>\n    <td>");
    // 161, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getUsedHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 162, 55
    jamonWriter.write("</td>\n    <td>");
    // 163, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMaxHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 164, 55
    jamonWriter.write("</td>\n    <td>");
    // 165, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMemstoreSizeInMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 166, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 169, 1
    
        }  else {

    // 172, 1
    {
      // 172, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 172, 40
    jamonWriter.write("\n");
    // 173, 1
    
        }
}

    // 177, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 76, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 80, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
    // 89, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }
    
    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
        lastContact = (System.currentTimeMillis() - sl.getReportTime())/1000;
    }
    long startcode = serverName.getStartcode();

    // 116, 1
    jamonWriter.write("<tr>\n    <td>");
    // 117, 9
    {
      // 117, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 117, 70
    jamonWriter.write("</td>\n    <td>");
    // 118, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 118, 34
    jamonWriter.write("</td>\n    <td>");
    // 119, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 119, 71
    jamonWriter.write("</td>\n    <td>");
    // 120, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 120, 22
    jamonWriter.write("</td>\n    <td>");
    // 121, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 121, 55
    jamonWriter.write("</td>\n    <td>");
    // 122, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 122, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 124, 1
    
}

    // 127, 1
    jamonWriter.write("<tr><td>Total:");
    // 127, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 127, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 130, 1
    if (inconsistentNodeNum > 0)
    {
      // 130, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 131, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 131, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 132, 1
    else
    {
      // 132, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 134, 7
    jamonWriter.write("\n<td>");
    // 135, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 135, 24
    jamonWriter.write("</td>\n<td>");
    // 136, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 136, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 260, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 264, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 272, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 283, 1
    jamonWriter.write("<tr>\n<td>");
    // 284, 5
    {
      // 284, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 284, 66
    jamonWriter.write("</td>\n<td>");
    // 285, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 285, 37
    jamonWriter.write("</td>\n<td>");
    // 286, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 286, 38
    jamonWriter.write("</td>\n<td>");
    // 287, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 287, 67
    jamonWriter.write("</td>\n<td>");
    // 288, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 288, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 290, 1
    
        }  else {
        
    // 293, 1
    {
      // 293, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 293, 40
    jamonWriter.write("\n");
    // 294, 1
    
    }
}

    // 298, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 216, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 220, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 230, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 236, 1
    jamonWriter.write("<tr>\n<td>");
    // 237, 5
    {
      // 237, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 237, 66
    jamonWriter.write("</td>\n<td>");
    // 238, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 238, 25
    jamonWriter.write("</td>\n<td>");
    // 239, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 239, 29
    jamonWriter.write("</td>\n<td>");
    // 240, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  sl.getStoreUncompressedSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 241, 83
    jamonWriter.write("</td>\n<td>");
    // 242, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getStorefileSizeInMB()
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 243, 51
    jamonWriter.write("</td>\n<td>");
    // 244, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticIndexSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 245, 51
    jamonWriter.write("</td>\n<td>");
    // 246, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticBloomSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 247, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 249, 1
    
        }  else {
        
    // 252, 1
    {
      // 252, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 252, 40
    jamonWriter.write("\n");
    // 253, 1
    
    }
}

    // 257, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
