// Autogenerated Jamon implementation
// /Users/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.ServerLoad;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 32, 9
import org.apache.hadoop.hbase.client.HConnectionManager;
// 33, 9
import org.apache.hadoop.hbase.HTableDescriptor;
// 34, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 36, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if ((servers != null && servers.size() > 0))
    {
      // 40, 47
      jamonWriter.write("\n\n");
      // 42, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 47, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 57, 13
      {
        // 57, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 57, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 60, 13
      {
        // 60, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 60, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 63, 13
      {
        // 63, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 63, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 66, 13
      {
        // 66, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 66, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 69, 13
      {
        // 69, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 69, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 74, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 176, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 180, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 187, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 193, 1
    jamonWriter.write("<tr>\n<td>");
    // 194, 5
    {
      // 194, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 194, 66
    jamonWriter.write("</td>\n<td>");
    // 195, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 195, 59
    jamonWriter.write("</td>\n<td>");
    // 196, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 196, 36
    jamonWriter.write("</td>\n<td>");
    // 197, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 197, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 199, 1
    
        }  else {
        
    // 202, 1
    {
      // 202, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 202, 40
    jamonWriter.write("\n");
    // 203, 1
    
        }
}

    // 207, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 314, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 318, 5
    jamonWriter.write("<tr>\n    <td>");
    // 319, 9
    {
      // 319, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 319, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 297, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerLoad serverLoad)
    throws java.io.IOException
  {
    // 302, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 307, 9
    if (infoPort > 0)
    {
      // 307, 28
      jamonWriter.write("\n            <a href=\"");
      // 308, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 308, 31
      jamonWriter.write("\">");
      // 308, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 308, 65
      jamonWriter.write("</a>\n        ");
    }
    // 309, 9
    else
    {
      // 309, 16
      jamonWriter.write("\n            ");
      // 310, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 310, 45
      jamonWriter.write("\n        ");
    }
    // 311, 15
    jamonWriter.write("\n");
  }
  
  
  // 136, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 140, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 148, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 154, 1
    jamonWriter.write("<tr>\n    <td>");
    // 155, 9
    {
      // 155, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 155, 70
    jamonWriter.write("</td>\n    <td>");
    // 156, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getUsedHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 157, 55
    jamonWriter.write("</td>\n    <td>");
    // 158, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMaxHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 159, 55
    jamonWriter.write("</td>\n    <td>");
    // 160, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMemstoreSizeInMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 161, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 164, 1
    
        }  else {

    // 167, 1
    {
      // 167, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 167, 40
    jamonWriter.write("\n");
    // 168, 1
    
        }
}

    // 172, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 76, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 80, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
    // 88, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }
    
    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
    }
    long startcode = serverName.getStartcode();

    // 113, 1
    jamonWriter.write("<tr>\n    <td>");
    // 114, 9
    {
      // 114, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 114, 70
    jamonWriter.write("</td>\n    <td>");
    // 115, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 115, 34
    jamonWriter.write("</td>\n    <td>");
    // 116, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 116, 22
    jamonWriter.write("</td>\n    <td>");
    // 117, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 117, 55
    jamonWriter.write("</td>\n    <td>");
    // 118, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 118, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 120, 1
    
}

    // 123, 1
    jamonWriter.write("<tr><td>Total:");
    // 123, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 123, 35
    jamonWriter.write("</td>\n<td></td>\n");
    // 125, 1
    if (inconsistentNodeNum > 0)
    {
      // 125, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 126, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 126, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 127, 1
    else
    {
      // 127, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 129, 7
    jamonWriter.write("\n<td>");
    // 130, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 130, 24
    jamonWriter.write("</td>\n<td>");
    // 131, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 131, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 255, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 259, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 267, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 278, 1
    jamonWriter.write("<tr>\n<td>");
    // 279, 5
    {
      // 279, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 279, 66
    jamonWriter.write("</td>\n<td>");
    // 280, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 280, 37
    jamonWriter.write("</td>\n<td>");
    // 281, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 281, 38
    jamonWriter.write("</td>\n<td>");
    // 282, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 282, 67
    jamonWriter.write("</td>\n<td>");
    // 283, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 283, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 285, 1
    
        }  else {
        
    // 288, 1
    {
      // 288, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 288, 40
    jamonWriter.write("\n");
    // 289, 1
    
    }
}

    // 293, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 211, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 215, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 225, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 231, 1
    jamonWriter.write("<tr>\n<td>");
    // 232, 5
    {
      // 232, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 232, 66
    jamonWriter.write("</td>\n<td>");
    // 233, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 233, 25
    jamonWriter.write("</td>\n<td>");
    // 234, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 234, 29
    jamonWriter.write("</td>\n<td>");
    // 235, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  sl.getStoreUncompressedSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 236, 83
    jamonWriter.write("</td>\n<td>");
    // 237, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getStorefileSizeInMB()
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 238, 51
    jamonWriter.write("</td>\n<td>");
    // 239, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticIndexSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 240, 51
    jamonWriter.write("</td>\n<td>");
    // 241, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticBloomSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 242, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 244, 1
    
        }  else {
        
    // 247, 1
    {
      // 247, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 247, 40
    jamonWriter.write("\n");
    // 248, 1
    
    }
}

    // 252, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
