/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class AuthResult {
    private boolean allowed;
    private final String namespace;
    private final TableName table;
    private final Permission.Action action;
    private final String request;
    private String reason;
    private final User user;
    private final byte[] family;
    private final byte[] qualifier;
    private final Map<byte[], ? extends Collection<?>> families;

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
        this.action = action;
        this.families = null;
        this.namespace = null;
    }

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.table = table;
        this.family = null;
        this.qualifier = null;
        this.action = action;
        this.families = families;
        this.namespace = null;
    }

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, String namespace) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.namespace = namespace;
        this.action = action;
        this.table = null;
        this.family = null;
        this.qualifier = null;
        this.families = null;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public User getUser() {
        return this.user;
    }

    public String getReason() {
        return this.reason;
    }

    public TableName getTableName() {
        return this.table;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public Permission.Action getAction() {
        return this.action;
    }

    public String getRequest() {
        return this.request;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    String toFamilyString() {
        StringBuilder sb = new StringBuilder();
        if (this.families != null) {
            boolean first = true;
            for (Map.Entry<byte[], Collection<?>> entry : this.families.entrySet()) {
                String familyName = Bytes.toString((byte[])entry.getKey());
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    for (Object o : entry.getValue()) {
                        String qualifier;
                        if (o instanceof byte[]) {
                            qualifier = Bytes.toString((byte[])((byte[])o));
                        } else if (o instanceof Cell) {
                            Cell c = (Cell)o;
                            qualifier = Bytes.toString((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength());
                        } else {
                            qualifier = o.toString();
                        }
                        if (!first) {
                            sb.append("|");
                        }
                        first = false;
                        sb.append(familyName).append(":").append(qualifier);
                    }
                    continue;
                }
                if (!first) {
                    sb.append("|");
                }
                first = false;
                sb.append(familyName);
            }
        } else if (this.family != null) {
            sb.append(Bytes.toString((byte[])this.family));
            if (this.qualifier != null) {
                sb.append(":").append(Bytes.toString((byte[])this.qualifier));
            }
        }
        return sb.toString();
    }

    public String toContextString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(user=").append(this.user != null ? this.user.getName() : "UNKNOWN").append(", ");
        sb.append("scope=").append((Object)(this.namespace != null ? this.namespace : (this.table == null ? "GLOBAL" : this.table))).append(", ");
        if (this.namespace == null) {
            sb.append("family=").append(this.toFamilyString()).append(", ");
        }
        sb.append("action=").append(this.action != null ? this.action.toString() : "").append(")");
        return sb.toString();
    }

    public String toString() {
        return "AuthResult" + this.toContextString();
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, String namespace) {
        return new AuthResult(true, request, reason, user, action, namespace);
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        return new AuthResult(true, request, reason, user, action, table, family, qualifier);
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        return new AuthResult(true, request, reason, user, action, table, families);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, String namespace) {
        return new AuthResult(false, request, reason, user, action, namespace);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        return new AuthResult(false, request, reason, user, action, table, family, qualifier);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        return new AuthResult(false, request, reason, user, action, table, families);
    }
}

