/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;

@InterfaceAudience.Private
public class StripeStoreFlusher
extends StoreFlusher {
    private static final Log LOG = LogFactory.getLog(StripeStoreFlusher.class);
    private final Object flushLock = new Object();
    private final StripeCompactionPolicy policy;
    private final StripeCompactionPolicy.StripeInformationProvider stripes;

    public StripeStoreFlusher(Configuration conf, Store store, StripeCompactionPolicy policy, StripeStoreFileManager stripes) {
        super(conf, store);
        this.policy = policy;
        this.stripes = stripes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(SortedSet<KeyValue> snapshot, long cacheFlushSeqNum, TimeRangeTracker tracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
        List<Path> result = new ArrayList<Path>();
        int kvCount = snapshot.size();
        if (kvCount == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        InternalScanner scanner = this.createScanner(snapshot, smallestReadPoint);
        if (scanner == null) {
            return result;
        }
        StripeFlushRequest req = this.policy.selectFlush(this.stripes, kvCount);
        long flushedBytes = 0L;
        boolean success = false;
        StripeMultiFileWriter mw = null;
        try {
            mw = req.createWriter();
            StripeMultiFileWriter.WriterFactory factory = this.createWriterFactory(tracker, kvCount);
            StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
            mw.init(storeScanner, factory, this.store.getComparator());
            Object object = this.flushLock;
            synchronized (object) {
                flushedBytes = this.performFlush(scanner, mw, smallestReadPoint);
                result = mw.commitWriters(cacheFlushSeqNum, false);
                success = true;
            }
        }
        finally {
            if (!success && mw != null) {
                for (Path leftoverFile : mw.abortWriters()) {
                    try {
                        this.store.getFileSystem().delete(leftoverFile, false);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to delete a file after failed flush: " + e));
                    }
                }
            }
            flushedSize.set(flushedBytes);
            try {
                scanner.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to close flush scanner, ignoring", (Throwable)ex);
            }
        }
        return result;
    }

    private StripeMultiFileWriter.WriterFactory createWriterFactory(final TimeRangeTracker tracker, final long kvCount) {
        return new StripeMultiFileWriter.WriterFactory(){

            @Override
            public StoreFile.Writer createWriter() throws IOException {
                StoreFile.Writer writer = StripeStoreFlusher.this.store.createWriterInTmp(kvCount, StripeStoreFlusher.this.store.getFamily().getCompression(), false, true, true);
                writer.setTimeRangeTracker(tracker);
                return writer;
            }
        };
    }

    public static class SizeStripeFlushRequest
    extends StripeFlushRequest {
        private final int targetCount;
        private final long targetKvs;

        public SizeStripeFlushRequest(int targetCount, long targetKvs) {
            this.targetCount = targetCount;
            this.targetKvs = targetKvs;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.SizeMultiWriter(this.targetCount, this.targetKvs, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
        }
    }

    public static class BoundaryStripeFlushRequest
    extends StripeFlushRequest {
        private final List<byte[]> targetBoundaries;

        public BoundaryStripeFlushRequest(List<byte[]> targetBoundaries) {
            this.targetBoundaries = targetBoundaries;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.BoundaryMultiWriter(this.targetBoundaries, null, null);
        }
    }

    public static class StripeFlushRequest {
        @VisibleForTesting
        public StripeMultiFileWriter createWriter() throws IOException {
            StripeMultiFileWriter.SizeMultiWriter writer = new StripeMultiFileWriter.SizeMultiWriter(1, Long.MAX_VALUE, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
            writer.setNoStripeMetadata();
            return writer;
        }
    }
}

