/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class BucketCacheStats
extends CacheStats {
    private final AtomicLong ioHitCount = new AtomicLong(0L);
    private final AtomicLong ioHitTime = new AtomicLong(0L);
    private static final int nanoTime = 1000000;
    private long lastLogTime = EnvironmentEdgeManager.currentTimeMillis();

    @Override
    public String toString() {
        return super.toString() + ", ioHitsPerSecond=" + this.getIOHitsPerSecond() + ", ioTimePerHit=" + this.getIOTimePerHit();
    }

    public void ioHit(long time) {
        this.ioHitCount.incrementAndGet();
        this.ioHitTime.addAndGet(time);
    }

    public long getIOHitsPerSecond() {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        long took = (now - this.lastLogTime) / 1000L;
        this.lastLogTime = now;
        return took == 0L ? 0L : this.ioHitCount.get() / took;
    }

    public double getIOTimePerHit() {
        long time = this.ioHitTime.get() / 1000000L;
        long count = this.ioHitCount.get();
        return (float)time / (float)count;
    }

    public void reset() {
        this.ioHitCount.set(0L);
        this.ioHitTime.set(0L);
    }
}

