/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;

public class ChecksumUtil {
    private static byte[] DUMMY_VALUE = new byte[512];
    private static boolean generateExceptions = false;

    static void generateChecksums(byte[] indata, int startOffset, int endOffset, byte[] outdata, int outOffset, ChecksumType checksumType, int bytesPerChecksum) throws IOException {
        int count;
        if (checksumType == ChecksumType.NULL) {
            return;
        }
        Checksum checksum = checksumType.getChecksumObject();
        int chunkNum = 0;
        for (int bytesLeft = endOffset - startOffset; bytesLeft > 0; bytesLeft -= count) {
            checksum.reset();
            count = Math.min(bytesLeft, bytesPerChecksum);
            checksum.update(indata, startOffset, count);
            int cksumValue = (int)checksum.getValue();
            outOffset = Bytes.putInt((byte[])outdata, (int)outOffset, (int)cksumValue);
            ++chunkNum;
            startOffset += count;
        }
    }

    static boolean validateBlockChecksum(Path path, HFileBlock block, byte[] data, int hdrSize) throws IOException {
        if (!block.getHFileContext().isUseHBaseChecksum()) {
            return false;
        }
        ChecksumType cktype = ChecksumType.codeToType((byte)block.getChecksumType());
        if (cktype == ChecksumType.NULL) {
            return true;
        }
        Checksum checksumObject = cktype.getChecksumObject();
        checksumObject.reset();
        int bytesPerChecksum = block.getBytesPerChecksum();
        if (bytesPerChecksum < hdrSize) {
            String msg = "Unsupported value of bytesPerChecksum.  Minimum is " + hdrSize + " but the configured value is " + bytesPerChecksum;
            HFile.LOG.warn((Object)msg);
            return false;
        }
        ByteBuffer hdr = block.getBufferWithHeader();
        checksumObject.update(hdr.array(), hdr.arrayOffset(), hdrSize);
        int off = hdrSize;
        int consumed = hdrSize;
        int bytesLeft = block.getOnDiskDataSizeWithHeader() - off;
        int cksumOffset = block.getOnDiskDataSizeWithHeader();
        while (bytesLeft > 0) {
            int thisChunkSize = bytesPerChecksum - consumed;
            int count = Math.min(bytesLeft, thisChunkSize);
            checksumObject.update(data, off, count);
            int storedChecksum = Bytes.toInt((byte[])data, (int)cksumOffset);
            if (storedChecksum != (int)checksumObject.getValue()) {
                String msg = "File " + path + " Stored checksum value of " + storedChecksum + " at offset " + cksumOffset + " does not match computed checksum " + checksumObject.getValue() + ", total data size " + data.length + " Checksum data range offset " + off + " len " + count + HFileBlock.toStringHeader(block.getBufferReadOnly());
                HFile.LOG.warn((Object)msg);
                if (generateExceptions) {
                    throw new IOException(msg);
                }
                return false;
            }
            cksumOffset += 4;
            bytesLeft -= count;
            off += count;
            consumed = 0;
            checksumObject.reset();
        }
        return true;
    }

    static long numBytes(long datasize, int bytesPerChecksum) {
        return ChecksumUtil.numChunks(datasize, bytesPerChecksum) * 4L;
    }

    static long numChunks(long datasize, int bytesPerChecksum) {
        long numChunks = datasize / (long)bytesPerChecksum;
        if (datasize % (long)bytesPerChecksum != 0L) {
            ++numChunks;
        }
        return numChunks;
    }

    static void reserveSpaceForChecksums(ByteArrayOutputStream baos, int numBytes, int bytesPerChecksum) throws IOException {
        long count;
        long numChunks = ChecksumUtil.numChunks(numBytes, bytesPerChecksum);
        for (long bytesLeft = numChunks * 4L; bytesLeft > 0L; bytesLeft -= count) {
            count = Math.min(bytesLeft, (long)DUMMY_VALUE.length);
            baos.write(DUMMY_VALUE, 0, (int)count);
        }
    }

    public static void generateExceptionForChecksumFailureForTest(boolean value) {
        generateExceptions = value;
    }
}

