/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.DoubleBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class CacheConfig {
    private static final Log LOG = LogFactory.getLog((String)CacheConfig.class.getName());
    public static final String CACHE_BLOCKS_ON_WRITE_KEY = "hbase.rs.cacheblocksonwrite";
    public static final String CACHE_INDEX_BLOCKS_ON_WRITE_KEY = "hfile.block.index.cacheonwrite";
    public static final String CACHE_BLOOM_BLOCKS_ON_WRITE_KEY = "hfile.block.bloom.cacheonwrite";
    public static final String CACHE_DATA_BLOCKS_COMPRESSED_KEY = "hbase.block.data.cachecompressed";
    public static final String EVICT_BLOCKS_ON_CLOSE_KEY = "hbase.rs.evictblocksonclose";
    public static final String BUCKET_CACHE_IOENGINE_KEY = "hbase.bucketcache.ioengine";
    public static final String BUCKET_CACHE_SIZE_KEY = "hbase.bucketcache.size";
    public static final String BUCKET_CACHE_PERSISTENT_PATH_KEY = "hbase.bucketcache.persistent.path";
    public static final String BUCKET_CACHE_COMBINED_KEY = "hbase.bucketcache.combinedcache.enabled";
    public static final String BUCKET_CACHE_COMBINED_PERCENTAGE_KEY = "hbase.bucketcache.percentage.in.combinedcache";
    public static final String BUCKET_CACHE_WRITER_THREADS_KEY = "hbase.bucketcache.writer.threads";
    public static final String BUCKET_CACHE_WRITER_QUEUE_KEY = "hbase.bucketcache.writer.queuelength";
    public static final String BUCKET_CACHE_BUCKETS_KEY = "hbase.bucketcache.bucket.sizes";
    public static final boolean DEFAULT_BUCKET_CACHE_COMBINED = true;
    public static final int DEFAULT_BUCKET_CACHE_WRITER_THREADS = 3;
    public static final int DEFAULT_BUCKET_CACHE_WRITER_QUEUE = 64;
    public static final float DEFAULT_BUCKET_CACHE_COMBINED_PERCENTAGE = 0.9f;
    public static final String PREFETCH_BLOCKS_ON_OPEN_KEY = "hbase.rs.prefetchblocksonopen";
    public static final String BLOCKCACHE_BLOCKSIZE_KEY = "hbase.offheapcache.minblocksize";
    public static final boolean DEFAULT_CACHE_DATA_ON_READ = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_CACHE_INDEXES_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final boolean DEFAULT_EVICT_ON_CLOSE = false;
    public static final boolean DEFAULT_CACHE_DATA_COMPRESSED = false;
    public static final boolean DEFAULT_PREFETCH_ON_OPEN = false;
    private final BlockCache blockCache;
    private boolean cacheDataOnRead;
    private final boolean inMemory;
    private boolean cacheDataOnWrite;
    private final boolean cacheIndexesOnWrite;
    private final boolean cacheBloomsOnWrite;
    private boolean evictOnClose;
    private final boolean cacheDataCompressed;
    private final boolean prefetchOnOpen;
    @VisibleForTesting
    static BlockCache GLOBAL_BLOCK_CACHE_INSTANCE;
    private static boolean blockCacheDisabled;

    public CacheConfig(Configuration conf, HColumnDescriptor family) {
        this(CacheConfig.instantiateBlockCache(conf), family.isBlockCacheEnabled(), family.isInMemory(), conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheDataOnWrite(), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheIndexesOnWrite(), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheBloomsOnWrite(), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false) || family.shouldEvictBlocksOnClose(), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false), conf.getBoolean(PREFETCH_BLOCKS_ON_OPEN_KEY, false) || family.shouldPrefetchBlocksOnOpen());
    }

    public CacheConfig(Configuration conf) {
        this(CacheConfig.instantiateBlockCache(conf), true, false, conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false), conf.getBoolean(PREFETCH_BLOCKS_ON_OPEN_KEY, false));
    }

    CacheConfig(BlockCache blockCache, boolean cacheDataOnRead, boolean inMemory, boolean cacheDataOnWrite, boolean cacheIndexesOnWrite, boolean cacheBloomsOnWrite, boolean evictOnClose, boolean cacheDataCompressed, boolean prefetchOnOpen) {
        this.blockCache = blockCache;
        this.cacheDataOnRead = cacheDataOnRead;
        this.inMemory = inMemory;
        this.cacheDataOnWrite = cacheDataOnWrite;
        this.cacheIndexesOnWrite = cacheIndexesOnWrite;
        this.cacheBloomsOnWrite = cacheBloomsOnWrite;
        this.evictOnClose = evictOnClose;
        this.cacheDataCompressed = cacheDataCompressed;
        this.prefetchOnOpen = prefetchOnOpen;
    }

    public CacheConfig(CacheConfig cacheConf) {
        this(cacheConf.blockCache, cacheConf.cacheDataOnRead, cacheConf.inMemory, cacheConf.cacheDataOnWrite, cacheConf.cacheIndexesOnWrite, cacheConf.cacheBloomsOnWrite, cacheConf.evictOnClose, cacheConf.cacheDataCompressed, cacheConf.prefetchOnOpen);
    }

    public boolean isBlockCacheEnabled() {
        return this.blockCache != null;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public boolean shouldCacheDataOnRead() {
        return this.isBlockCacheEnabled() && this.cacheDataOnRead;
    }

    public boolean shouldCacheBlockOnRead(BlockType.BlockCategory category) {
        return this.isBlockCacheEnabled() && (this.cacheDataOnRead || category == BlockType.BlockCategory.INDEX || category == BlockType.BlockCategory.BLOOM || this.prefetchOnOpen && category != BlockType.BlockCategory.META && category != BlockType.BlockCategory.UNKNOWN);
    }

    public boolean isInMemory() {
        return this.isBlockCacheEnabled() && this.inMemory;
    }

    public boolean shouldCacheDataOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheDataOnWrite;
    }

    public void setCacheDataOnWrite(boolean cacheDataOnWrite) {
        this.cacheDataOnWrite = cacheDataOnWrite;
    }

    public boolean shouldCacheIndexesOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheIndexesOnWrite;
    }

    public boolean shouldCacheBloomsOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheBloomsOnWrite;
    }

    public boolean shouldEvictOnClose() {
        return this.isBlockCacheEnabled() && this.evictOnClose;
    }

    public void setEvictOnClose(boolean evictOnClose) {
        this.evictOnClose = evictOnClose;
    }

    public boolean shouldCacheDataCompressed() {
        return this.isBlockCacheEnabled() && this.cacheDataCompressed;
    }

    public boolean shouldCacheCompressed(BlockType.BlockCategory category) {
        if (!this.isBlockCacheEnabled()) {
            return false;
        }
        switch (category) {
            case DATA: {
                return this.cacheDataCompressed;
            }
        }
        return false;
    }

    public boolean shouldPrefetchOnOpen() {
        return this.isBlockCacheEnabled() && this.prefetchOnOpen;
    }

    public String toString() {
        if (!this.isBlockCacheEnabled()) {
            return "CacheConfig:disabled";
        }
        return "CacheConfig:enabled [cacheDataOnRead=" + this.shouldCacheDataOnRead() + "] " + "[cacheDataOnWrite=" + this.shouldCacheDataOnWrite() + "] " + "[cacheIndexesOnWrite=" + this.shouldCacheIndexesOnWrite() + "] " + "[cacheBloomsOnWrite=" + this.shouldCacheBloomsOnWrite() + "] " + "[cacheEvictOnClose=" + this.shouldEvictOnClose() + "] " + "[cacheDataCompressed=" + this.shouldCacheDataCompressed() + "] " + "[prefetchOnOpen=" + this.shouldPrefetchOnOpen() + "]";
    }

    private static synchronized BlockCache instantiateBlockCache(Configuration conf) {
        if (GLOBAL_BLOCK_CACHE_INSTANCE != null) {
            return GLOBAL_BLOCK_CACHE_INSTANCE;
        }
        if (blockCacheDisabled) {
            return null;
        }
        float cachePercentage = conf.getFloat("hfile.block.cache.size", 0.25f);
        if (cachePercentage == 0.0f) {
            blockCacheDisabled = true;
            return null;
        }
        if ((double)cachePercentage > 1.0) {
            throw new IllegalArgumentException("hfile.block.cache.size must be between 0.0 and 1.0, and not > 1.0");
        }
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long lruCacheSize = (long)((float)mu.getMax() * cachePercentage);
        int blockSize = conf.getInt(BLOCKCACHE_BLOCKSIZE_KEY, 65536);
        long offHeapCacheSize = (long)(conf.getFloat("hbase.offheapcache.percentage", 0.0f) * (float)DirectMemoryUtils.getDirectMemorySize());
        if (offHeapCacheSize <= 0L) {
            String bucketCacheIOEngineName = conf.get(BUCKET_CACHE_IOENGINE_KEY, null);
            float bucketCachePercentage = conf.getFloat(BUCKET_CACHE_SIZE_KEY, 0.0f);
            long bucketCacheSize = (long)(bucketCachePercentage < 1.0f ? (float)mu.getMax() * bucketCachePercentage : bucketCachePercentage * 1024.0f * 1024.0f);
            boolean combinedWithLru = conf.getBoolean(BUCKET_CACHE_COMBINED_KEY, true);
            BucketCache bucketCache = null;
            if (bucketCacheIOEngineName != null && bucketCacheSize > 0L) {
                int writerThreads = conf.getInt(BUCKET_CACHE_WRITER_THREADS_KEY, 3);
                int writerQueueLen = conf.getInt(BUCKET_CACHE_WRITER_QUEUE_KEY, 64);
                String persistentPath = conf.get(BUCKET_CACHE_PERSISTENT_PATH_KEY);
                float combinedPercentage = conf.getFloat(BUCKET_CACHE_COMBINED_PERCENTAGE_KEY, 0.9f);
                String[] configuredBucketSizes = conf.getStrings(BUCKET_CACHE_BUCKETS_KEY);
                int[] bucketSizes = null;
                if (configuredBucketSizes != null) {
                    bucketSizes = new int[configuredBucketSizes.length];
                    for (int i = 0; i < configuredBucketSizes.length; ++i) {
                        bucketSizes[i] = Integer.parseInt(configuredBucketSizes[i].trim());
                    }
                }
                if (combinedWithLru) {
                    lruCacheSize = (long)((1.0f - combinedPercentage) * (float)bucketCacheSize);
                    bucketCacheSize = (long)(combinedPercentage * (float)bucketCacheSize);
                }
                try {
                    int ioErrorsTolerationDuration = conf.getInt("hbase.bucketcache.ioengine.errors.tolerated.duration", 60000);
                    bucketCache = new BucketCache(bucketCacheIOEngineName, bucketCacheSize, blockSize, bucketSizes, writerThreads, writerQueueLen, persistentPath, ioErrorsTolerationDuration);
                }
                catch (IOException ioex) {
                    LOG.error((Object)"Can't instantiate bucket cache", (Throwable)ioex);
                    throw new RuntimeException(ioex);
                }
            }
            LOG.info((Object)("Allocating LruBlockCache with maximum size " + StringUtils.humanReadableInt((long)lruCacheSize)));
            LruBlockCache lruCache = new LruBlockCache(lruCacheSize, blockSize, true, conf);
            lruCache.setVictimCache(bucketCache);
            GLOBAL_BLOCK_CACHE_INSTANCE = bucketCache != null && combinedWithLru ? new CombinedBlockCache(lruCache, bucketCache) : lruCache;
        } else {
            LOG.warn((Object)"SlabCache is deprecated. Consider BucketCache as a replacement.");
            GLOBAL_BLOCK_CACHE_INSTANCE = new DoubleBlockCache(lruCacheSize, offHeapCacheSize, blockSize, blockSize, conf);
        }
        return GLOBAL_BLOCK_CACHE_INSTANCE;
    }

    static {
        blockCacheDisabled = false;
    }
}

