/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.channel.CoalescingBufferQueue;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.PromiseCombiner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CryptoAESWrapHandler
extends ChannelOutboundHandlerAdapter {
    private final CryptoAES cryptoAES;
    private CoalescingBufferQueue queue;

    public CryptoAESWrapHandler(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.queue = new CoalescingBufferQueue(ctx.channel());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.queue.add((ByteBuf)msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.queue.isEmpty()) {
            return;
        }
        ByteBuf buf = null;
        try {
            ChannelPromise promise = ctx.newPromise();
            int readableBytes = this.queue.readableBytes();
            buf = this.queue.remove(readableBytes, promise);
            byte[] bytes = new byte[readableBytes];
            buf.readBytes(bytes);
            byte[] wrapperBytes = this.cryptoAES.wrap(bytes, 0, bytes.length);
            ChannelPromise lenPromise = ctx.newPromise();
            ctx.write((Object)ctx.alloc().buffer(4).writeInt(wrapperBytes.length), lenPromise);
            ChannelPromise contentPromise = ctx.newPromise();
            ctx.write((Object)Unpooled.wrappedBuffer((byte[])wrapperBytes), contentPromise);
            PromiseCombiner combiner = new PromiseCombiner();
            combiner.addAll(new Promise[]{lenPromise, contentPromise});
            combiner.finish((Promise)promise);
            ctx.flush();
            if (buf == null) return;
        }
        catch (Throwable throwable) {
            if (buf == null) throw throwable;
            ReferenceCountUtil.safeRelease(buf);
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)buf);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.queue.isEmpty()) {
            this.queue.releaseAndFailAll((Throwable)((Object)new ConnectionClosedException("Connection closed")));
        }
        ctx.close(promise);
    }
}

