/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZNodePaths {
    public static final char ZNODE_PATH_SEPARATOR = '/';
    public static final String META_ZNODE_PREFIX = "meta-region-server";
    public final String baseZNode;
    public final String metaZNodePrefix;
    public final ImmutableMap<Integer, String> metaReplicaZNodes;
    public final String rsZNode;
    public final String drainingZNode;
    public final String masterAddressZNode;
    public final String backupMasterAddressesZNode;
    public final String clusterStateZNode;
    @Deprecated
    public final String tableZNode;
    public final String clusterIdZNode;
    public final String splitLogZNode;
    public final String balancerZNode;
    public final String regionNormalizerZNode;
    public final String switchZNode;
    public final String tableLockZNode;
    public final String namespaceZNode;
    public final String masterMaintZNode;
    public final String replicationZNode;
    public final String peersZNode;
    public final String queuesZNode;
    public final String hfileRefsZNode;

    public ZNodePaths(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.metaZNodePrefix = conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX);
        String defaultMetaReplicaZNode = ZNodePaths.joinZNode(this.baseZNode, this.metaZNodePrefix);
        builder.put((Object)0, (Object)defaultMetaReplicaZNode);
        int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
        IntStream.range(1, numMetaReplicas).forEachOrdered(i -> builder.put((Object)i, (Object)(defaultMetaReplicaZNode + "-" + i)));
        this.metaReplicaZNodes = builder.build();
        this.rsZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.tableZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitWAL"));
        this.balancerZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.regionNormalizerZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.regionNormalizer", "normalizer"));
        this.switchZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.switch", "switch"));
        this.tableLockZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableLock", "table-lock"));
        this.namespaceZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.namespace", "namespace"));
        this.masterMaintZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterMaintenance", "master-maintenance"));
        this.replicationZNode = ZNodePaths.joinZNode(this.baseZNode, conf.get("zookeeper.znode.replication", "replication"));
        this.peersZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.peers", "peers"));
        this.queuesZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.rs", "rs"));
        this.hfileRefsZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get("zookeeper.znode.replication.hfile.refs", "hfile-refs"));
    }

    public String toString() {
        return "ZNodePaths [baseZNode=" + this.baseZNode + ", metaReplicaZNodes=" + this.metaReplicaZNodes + ", rsZNode=" + this.rsZNode + ", drainingZNode=" + this.drainingZNode + ", masterAddressZNode=" + this.masterAddressZNode + ", backupMasterAddressesZNode=" + this.backupMasterAddressesZNode + ", clusterStateZNode=" + this.clusterStateZNode + ", tableZNode=" + this.tableZNode + ", clusterIdZNode=" + this.clusterIdZNode + ", splitLogZNode=" + this.splitLogZNode + ", balancerZNode=" + this.balancerZNode + ", regionNormalizerZNode=" + this.regionNormalizerZNode + ", switchZNode=" + this.switchZNode + ", tableLockZNode=" + this.tableLockZNode + ", namespaceZNode=" + this.namespaceZNode + ", masterMaintZNode=" + this.masterMaintZNode + ", replicationZNode=" + this.replicationZNode + ", peersZNode=" + this.peersZNode + ", queuesZNode=" + this.queuesZNode + ", hfileRefsZNode=" + this.hfileRefsZNode + "]";
    }

    public boolean isAnyMetaReplicaZNode(String node) {
        return this.metaReplicaZNodes.containsValue((Object)node);
    }

    public String getZNodeForReplica(int replicaId) {
        return Optional.ofNullable(this.metaReplicaZNodes.get((Object)replicaId)).orElseGet(() -> (String)this.metaReplicaZNodes.get((Object)0) + "-" + replicaId);
    }

    public int getMetaReplicaIdFromZnode(String znode) {
        if (znode.equals(this.metaZNodePrefix)) {
            return 0;
        }
        return Integer.parseInt(znode.substring(this.metaZNodePrefix.length() + 1));
    }

    public boolean isDefaultMetaReplicaZnode(String znode) {
        return ((String)this.metaReplicaZNodes.get((Object)0)).equals(znode);
    }

    public boolean isClientReadable(String node) {
        return node.equals(this.baseZNode) || this.isAnyMetaReplicaZNode(node) || node.equals(this.masterAddressZNode) || node.equals(this.clusterIdZNode) || node.equals(this.rsZNode) || node.equals(this.tableZNode) || node.startsWith(this.tableZNode + "/");
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }
}

