/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Admin
extends Abortable,
Closeable {
    public int getOperationTimeout();

    @Override
    public void abort(String var1, Throwable var2);

    @Override
    public boolean isAborted();

    public Connection getConnection();

    public boolean tableExists(TableName var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] listTables() throws IOException;

    public List<TableDescriptor> listTableDescriptors() throws IOException;

    @Deprecated
    public HTableDescriptor[] listTables(Pattern var1) throws IOException;

    public List<TableDescriptor> listTableDescriptors(Pattern var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] listTables(String var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] listTables(Pattern var1, boolean var2) throws IOException;

    public List<TableDescriptor> listTableDescriptors(Pattern var1, boolean var2) throws IOException;

    @Deprecated
    public HTableDescriptor[] listTables(String var1, boolean var2) throws IOException;

    public TableName[] listTableNames() throws IOException;

    public TableName[] listTableNames(Pattern var1) throws IOException;

    @Deprecated
    public TableName[] listTableNames(String var1) throws IOException;

    public TableName[] listTableNames(Pattern var1, boolean var2) throws IOException;

    @Deprecated
    public TableName[] listTableNames(String var1, boolean var2) throws IOException;

    @Deprecated
    public HTableDescriptor getTableDescriptor(TableName var1) throws TableNotFoundException, IOException;

    public TableDescriptor getDescriptor(TableName var1) throws TableNotFoundException, IOException;

    public void createTable(TableDescriptor var1) throws IOException;

    public void createTable(TableDescriptor var1, byte[] var2, byte[] var3, int var4) throws IOException;

    public void createTable(TableDescriptor var1, byte[][] var2) throws IOException;

    public Future<Void> createTableAsync(TableDescriptor var1, byte[][] var2) throws IOException;

    public void deleteTable(TableName var1) throws IOException;

    public Future<Void> deleteTableAsync(TableName var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] deleteTables(String var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] deleteTables(Pattern var1) throws IOException;

    public void truncateTable(TableName var1, boolean var2) throws IOException;

    public Future<Void> truncateTableAsync(TableName var1, boolean var2) throws IOException;

    public void enableTable(TableName var1) throws IOException;

    public Future<Void> enableTableAsync(TableName var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] enableTables(String var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] enableTables(Pattern var1) throws IOException;

    public Future<Void> disableTableAsync(TableName var1) throws IOException;

    public void disableTable(TableName var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] disableTables(String var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] disableTables(Pattern var1) throws IOException;

    public boolean isTableEnabled(TableName var1) throws IOException;

    public boolean isTableDisabled(TableName var1) throws IOException;

    public boolean isTableAvailable(TableName var1) throws IOException;

    @Deprecated
    public boolean isTableAvailable(TableName var1, byte[][] var2) throws IOException;

    @Deprecated
    public Pair<Integer, Integer> getAlterStatus(TableName var1) throws IOException;

    @Deprecated
    public Pair<Integer, Integer> getAlterStatus(byte[] var1) throws IOException;

    @Deprecated
    default public void addColumn(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.addColumnFamily(tableName, columnFamily);
    }

    public void addColumnFamily(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    public Future<Void> addColumnFamilyAsync(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    @Deprecated
    public void deleteColumn(TableName var1, byte[] var2) throws IOException;

    public void deleteColumnFamily(TableName var1, byte[] var2) throws IOException;

    public Future<Void> deleteColumnFamilyAsync(TableName var1, byte[] var2) throws IOException;

    @Deprecated
    default public void modifyColumn(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyColumnFamily(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    public Future<Void> modifyColumnFamilyAsync(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    @Deprecated
    public void closeRegion(String var1, String var2) throws IOException;

    @Deprecated
    public void closeRegion(byte[] var1, String var2) throws IOException;

    @Deprecated
    public boolean closeRegionWithEncodedRegionName(String var1, String var2) throws IOException;

    @Deprecated
    public void closeRegion(ServerName var1, HRegionInfo var2) throws IOException;

    @Deprecated
    public List<HRegionInfo> getOnlineRegions(ServerName var1) throws IOException;

    public List<RegionInfo> getRegions(ServerName var1) throws IOException;

    public void flush(TableName var1) throws IOException;

    public void flushRegion(byte[] var1) throws IOException;

    public void flushRegionServer(ServerName var1) throws IOException;

    public void compact(TableName var1) throws IOException;

    public void compactRegion(byte[] var1) throws IOException;

    public void compact(TableName var1, byte[] var2) throws IOException;

    public void compactRegion(byte[] var1, byte[] var2) throws IOException;

    public void compact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void compact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    public void majorCompact(TableName var1) throws IOException;

    public void majorCompactRegion(byte[] var1) throws IOException;

    public void majorCompact(TableName var1, byte[] var2) throws IOException;

    public void majorCompactRegion(byte[] var1, byte[] var2) throws IOException;

    public void majorCompact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void majorCompact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    @Deprecated
    default public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
        if (major) {
            this.majorCompactRegionServer(sn);
        } else {
            this.compactRegionServer(sn);
        }
    }

    public void compactRegionServer(ServerName var1) throws IOException;

    public void majorCompactRegionServer(ServerName var1) throws IOException;

    public void move(byte[] var1, byte[] var2) throws IOException;

    public void assign(byte[] var1) throws IOException;

    public void unassign(byte[] var1, boolean var2) throws IOException;

    public void offline(byte[] var1) throws IOException;

    @Deprecated
    default public boolean setBalancerRunning(boolean on, boolean synchronous) throws IOException {
        return this.balancerSwitch(on, synchronous);
    }

    public boolean balancerSwitch(boolean var1, boolean var2) throws IOException;

    @Deprecated
    default public boolean balancer() throws IOException {
        return this.balance();
    }

    public boolean balance() throws IOException;

    @Deprecated
    default public boolean balancer(boolean force) throws IOException {
        return this.balance(force);
    }

    public boolean balance(boolean var1) throws IOException;

    public boolean isBalancerEnabled() throws IOException;

    public CacheEvictionStats clearBlockCache(TableName var1) throws IOException;

    public boolean normalize() throws IOException;

    public boolean isNormalizerEnabled() throws IOException;

    @Deprecated
    default public boolean setNormalizerRunning(boolean on) throws IOException {
        return this.normalizerSwitch(on);
    }

    public boolean normalizerSwitch(boolean var1) throws IOException;

    @Deprecated
    default public boolean enableCatalogJanitor(boolean enable) throws IOException {
        return this.catalogJanitorSwitch(enable);
    }

    public boolean catalogJanitorSwitch(boolean var1) throws IOException;

    @Deprecated
    default public int runCatalogScan() throws IOException {
        return this.runCatalogJanitor();
    }

    public int runCatalogJanitor() throws IOException;

    public boolean isCatalogJanitorEnabled() throws IOException;

    @Deprecated
    default public boolean setCleanerChoreRunning(boolean on) throws IOException {
        return this.cleanerChoreSwitch(on);
    }

    public boolean cleanerChoreSwitch(boolean var1) throws IOException;

    public boolean runCleanerChore() throws IOException;

    public boolean isCleanerChoreEnabled() throws IOException;

    @Deprecated
    public void mergeRegions(byte[] var1, byte[] var2, boolean var3) throws IOException;

    public Future<Void> mergeRegionsAsync(byte[] var1, byte[] var2, boolean var3) throws IOException;

    public Future<Void> mergeRegionsAsync(byte[][] var1, boolean var2) throws IOException;

    public void split(TableName var1) throws IOException;

    @Deprecated
    public void splitRegion(byte[] var1) throws IOException;

    public void split(TableName var1, byte[] var2) throws IOException;

    @Deprecated
    public void splitRegion(byte[] var1, byte[] var2) throws IOException;

    public Future<Void> splitRegionAsync(byte[] var1, byte[] var2) throws IOException;

    @Deprecated
    public void modifyTable(TableName var1, TableDescriptor var2) throws IOException;

    public void modifyTable(TableDescriptor var1) throws IOException;

    @Deprecated
    public Future<Void> modifyTableAsync(TableName var1, TableDescriptor var2) throws IOException;

    public Future<Void> modifyTableAsync(TableDescriptor var1) throws IOException;

    public void shutdown() throws IOException;

    public void stopMaster() throws IOException;

    public boolean isMasterInMaintenanceMode() throws IOException;

    public void stopRegionServer(String var1) throws IOException;

    @Deprecated
    default public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus(this.getClusterMetrics());
    }

    default public ClusterMetrics getClusterMetrics() throws IOException {
        return this.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> var1) throws IOException;

    default public ServerName getMaster() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER)).getMasterName();
    }

    default public Collection<ServerName> getBackupMasters() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.BACKUP_MASTERS)).getBackupMasterNames();
    }

    default public Collection<ServerName> getRegionServers() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet();
    }

    default public List<RegionMetrics> getRegionMetrics(ServerName serverName) throws IOException {
        return this.getRegionMetrics(serverName, null);
    }

    public List<RegionMetrics> getRegionMetrics(ServerName var1, TableName var2) throws IOException;

    public Configuration getConfiguration();

    public void createNamespace(NamespaceDescriptor var1) throws IOException;

    public Future<Void> createNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    public void modifyNamespace(NamespaceDescriptor var1) throws IOException;

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    public void deleteNamespace(String var1) throws IOException;

    public Future<Void> deleteNamespaceAsync(String var1) throws IOException;

    public NamespaceDescriptor getNamespaceDescriptor(String var1) throws NamespaceNotFoundException, IOException;

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException;

    @Deprecated
    public HTableDescriptor[] listTableDescriptorsByNamespace(String var1) throws IOException;

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] var1) throws IOException;

    public TableName[] listTableNamesByNamespace(String var1) throws IOException;

    @Deprecated
    public List<HRegionInfo> getTableRegions(TableName var1) throws IOException;

    public List<RegionInfo> getRegions(TableName var1) throws IOException;

    @Override
    public void close() throws IOException;

    @Deprecated
    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> var1) throws IOException;

    public List<TableDescriptor> listTableDescriptors(List<TableName> var1) throws IOException;

    @Deprecated
    public HTableDescriptor[] getTableDescriptors(List<String> var1) throws IOException;

    public boolean abortProcedure(long var1, boolean var3) throws IOException;

    public Future<Boolean> abortProcedureAsync(long var1, boolean var3) throws IOException;

    public String getProcedures() throws IOException;

    public String getLocks() throws IOException;

    public void rollWALWriter(ServerName var1) throws IOException, FailedLogCloseException;

    @Deprecated
    default public String[] getMasterCoprocessors() throws IOException {
        return (String[])this.getMasterCoprocessorNames().stream().toArray(String[]::new);
    }

    default public List<String> getMasterCoprocessorNames() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS)).getMasterCoprocessorNames();
    }

    public CompactionState getCompactionState(TableName var1) throws IOException;

    public CompactionState getCompactionState(TableName var1, CompactType var2) throws IOException;

    public CompactionState getCompactionStateForRegion(byte[] var1) throws IOException;

    public long getLastMajorCompactionTimestamp(TableName var1) throws IOException;

    public long getLastMajorCompactionTimestampForRegion(byte[] var1) throws IOException;

    public void snapshot(String var1, TableName var2) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(byte[] var1, TableName var2) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(String var1, TableName var2, SnapshotType var3) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(SnapshotDescription var1) throws IOException, SnapshotCreationException, IllegalArgumentException;

    @Deprecated
    default public void takeSnapshotAsync(SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        this.snapshotAsync(snapshot);
    }

    public void snapshotAsync(SnapshotDescription var1) throws IOException, SnapshotCreationException;

    public boolean isSnapshotFinished(SnapshotDescription var1) throws IOException, HBaseSnapshotException, UnknownSnapshotException;

    public void restoreSnapshot(byte[] var1) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1) throws IOException, RestoreSnapshotException;

    public Future<Void> restoreSnapshotAsync(String var1) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(byte[] var1, boolean var2) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1, boolean var2) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1, boolean var2, boolean var3) throws IOException, RestoreSnapshotException;

    public void cloneSnapshot(byte[] var1, TableName var2) throws IOException, TableExistsException, RestoreSnapshotException;

    public void cloneSnapshot(String var1, TableName var2, boolean var3) throws IOException, TableExistsException, RestoreSnapshotException;

    public void cloneSnapshot(String var1, TableName var2) throws IOException, TableExistsException, RestoreSnapshotException;

    public Future<Void> cloneSnapshotAsync(String var1, TableName var2) throws IOException, TableExistsException;

    public void execProcedure(String var1, String var2, Map<String, String> var3) throws IOException;

    @Deprecated
    default public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        return this.execProcedureWithReturn(signature, instance, props);
    }

    public byte[] execProcedureWithReturn(String var1, String var2, Map<String, String> var3) throws IOException;

    public boolean isProcedureFinished(String var1, String var2, Map<String, String> var3) throws IOException;

    public List<SnapshotDescription> listSnapshots() throws IOException;

    @Deprecated
    public List<SnapshotDescription> listSnapshots(String var1) throws IOException;

    public List<SnapshotDescription> listSnapshots(Pattern var1) throws IOException;

    @Deprecated
    public List<SnapshotDescription> listTableSnapshots(String var1, String var2) throws IOException;

    public List<SnapshotDescription> listTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void deleteSnapshot(byte[] var1) throws IOException;

    public void deleteSnapshot(String var1) throws IOException;

    @Deprecated
    public void deleteSnapshots(String var1) throws IOException;

    public void deleteSnapshots(Pattern var1) throws IOException;

    @Deprecated
    public void deleteTableSnapshots(String var1, String var2) throws IOException;

    public void deleteTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void setQuota(QuotaSettings var1) throws IOException;

    @Deprecated
    public QuotaRetriever getQuotaRetriever(QuotaFilter var1) throws IOException;

    public List<QuotaSettings> getQuota(QuotaFilter var1) throws IOException;

    public CoprocessorRpcChannel coprocessorService();

    public CoprocessorRpcChannel coprocessorService(ServerName var1);

    public void updateConfiguration(ServerName var1) throws IOException;

    public void updateConfiguration() throws IOException;

    default public int getMasterInfoPort() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_INFO_PORT)).getMasterInfoPort();
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException;

    @Deprecated
    default public boolean[] setSplitOrMergeEnabled(boolean enabled, boolean synchronous, MasterSwitchType ... switchTypes) throws IOException {
        boolean[] preValues = new boolean[switchTypes.length];
        block4: for (int i = 0; i < switchTypes.length; ++i) {
            switch (switchTypes[i]) {
                case SPLIT: {
                    preValues[i] = this.splitSwitch(enabled, synchronous);
                    continue block4;
                }
                case MERGE: {
                    preValues[i] = this.mergeSwitch(enabled, synchronous);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported switch type:" + (Object)((Object)switchTypes[i]));
                }
            }
        }
        return preValues;
    }

    public boolean splitSwitch(boolean var1, boolean var2) throws IOException;

    public boolean mergeSwitch(boolean var1, boolean var2) throws IOException;

    @Deprecated
    default public boolean isSplitOrMergeEnabled(MasterSwitchType switchType) throws IOException {
        switch (switchType) {
            case SPLIT: {
                return this.isSplitEnabled();
            }
            case MERGE: {
                return this.isMergeEnabled();
            }
        }
        throw new UnsupportedOperationException("Unsupported switch type:" + (Object)((Object)switchType));
    }

    public boolean isSplitEnabled() throws IOException;

    public boolean isMergeEnabled() throws IOException;

    default public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        this.addReplicationPeer(peerId, peerConfig, true);
    }

    public void addReplicationPeer(String var1, ReplicationPeerConfig var2, boolean var3) throws IOException;

    public void removeReplicationPeer(String var1) throws IOException;

    public void enableReplicationPeer(String var1) throws IOException;

    public void disableReplicationPeer(String var1) throws IOException;

    public ReplicationPeerConfig getReplicationPeerConfig(String var1) throws IOException;

    public void updateReplicationPeerConfig(String var1, ReplicationPeerConfig var2) throws IOException;

    public void appendReplicationPeerTableCFs(String var1, Map<TableName, List<String>> var2) throws ReplicationException, IOException;

    public void removeReplicationPeerTableCFs(String var1, Map<TableName, List<String>> var2) throws ReplicationException, IOException;

    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException;

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern var1) throws IOException;

    public void decommissionRegionServers(List<ServerName> var1, boolean var2) throws IOException;

    public List<ServerName> listDecommissionedRegionServers() throws IOException;

    public void recommissionRegionServer(ServerName var1, List<byte[]> var2) throws IOException;

    public List<TableCFs> listReplicatedTableCFs() throws IOException;

    public void enableTableReplication(TableName var1) throws IOException;

    public void disableTableReplication(TableName var1) throws IOException;

    public void clearCompactionQueues(ServerName var1, Set<String> var2) throws IOException, InterruptedException;

    default public List<ServerName> listDeadServers() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.DEAD_SERVERS)).getDeadServerNames();
    }

    public List<ServerName> clearDeadServers(List<ServerName> var1) throws IOException;
}

