/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class QueuePlacementRule {
    protected boolean create;
    public static final Logger LOG = LoggerFactory.getLogger((String)QueuePlacementRule.class.getName());

    public QueuePlacementRule initialize(boolean create, Map<String, String> args) {
        this.create = create;
        return this;
    }

    public String assignAppToQueue(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) throws IOException {
        String queue = this.getQueueForApp(requestedQueue, user, groups, configuredQueues);
        if (this.create || configuredQueues.get((Object)FSQueueType.LEAF).contains(queue) || configuredQueues.get((Object)FSQueueType.PARENT).contains(queue)) {
            return queue;
        }
        return "";
    }

    public void initializeFromXml(Element el) throws AllocationConfigurationException {
        boolean create = true;
        NamedNodeMap attributes = el.getAttributes();
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String key = node.getNodeName();
            String value = node.getNodeValue();
            if (key.equals("create")) {
                create = Boolean.parseBoolean(value);
                continue;
            }
            args.put(key, value);
        }
        this.initialize(create, args);
    }

    public abstract boolean isTerminal();

    protected abstract String getQueueForApp(String var1, String var2, Groups var3, Map<FSQueueType, Set<String>> var4) throws IOException;

    protected String cleanName(String name) {
        if ((name = name.trim()).contains(".")) {
            String converted = name.replaceAll("\\.", "_dot_");
            LOG.warn("Name " + name + " is converted to " + converted + " when it is used as a queue name.");
            return converted;
        }
        return name;
    }

    public static class Reject
    extends QueuePlacementRule {
        @Override
        public String assignAppToQueue(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) {
            return null;
        }

        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public static class Default
    extends QueuePlacementRule {
        @VisibleForTesting
        String defaultQueueName;

        @Override
        public QueuePlacementRule initialize(boolean create, Map<String, String> args) {
            if (this.defaultQueueName == null) {
                this.defaultQueueName = "root.default";
            }
            return super.initialize(create, args);
        }

        @Override
        public void initializeFromXml(Element el) throws AllocationConfigurationException {
            this.defaultQueueName = el.getAttribute("queue");
            if (this.defaultQueueName != null && !this.defaultQueueName.isEmpty()) {
                if (!this.defaultQueueName.startsWith("root.")) {
                    this.defaultQueueName = "root." + this.defaultQueueName;
                }
            } else {
                this.defaultQueueName = "root.default";
            }
            super.initializeFromXml(el);
        }

        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) {
            return this.defaultQueueName;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public static class Specified
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) {
            if (requestedQueue.equals("default")) {
                return "";
            }
            if (!requestedQueue.startsWith("root.")) {
                requestedQueue = "root." + requestedQueue;
            }
            return requestedQueue;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    public static class NestedUserQueue
    extends QueuePlacementRule {
        @VisibleForTesting
        QueuePlacementRule nestedRule;

        @Override
        public void initializeFromXml(Element el) throws AllocationConfigurationException {
            NodeList elements = el.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element;
                Node node = elements.item(i);
                if (!(node instanceof Element) || !"rule".equals((element = (Element)node).getTagName())) continue;
                QueuePlacementRule rule = QueuePlacementPolicy.createAndInitializeRule(node);
                if (rule == null) {
                    throw new AllocationConfigurationException("Unable to create nested rule in nestedUserQueue rule");
                }
                this.nestedRule = rule;
                break;
            }
            if (this.nestedRule == null) {
                throw new AllocationConfigurationException("No nested rule specified in <nestedUserQueue> rule");
            }
            super.initializeFromXml(el);
        }

        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) throws IOException {
            String queueName = this.nestedRule.assignAppToQueue(requestedQueue, user, groups, configuredQueues);
            if (queueName != null && queueName.length() != 0) {
                if (!queueName.startsWith("root.")) {
                    queueName = "root." + queueName;
                }
                if (configuredQueues.get((Object)FSQueueType.LEAF).contains(queueName)) {
                    return "";
                }
                return queueName + "." + this.cleanName(user);
            }
            return queueName;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    public static class SecondaryGroupExistingQueue
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) throws IOException {
            List groupNames = groups.getGroups(user);
            for (int i = 1; i < groupNames.size(); ++i) {
                String group = this.cleanName((String)groupNames.get(i));
                if (!configuredQueues.get((Object)FSQueueType.LEAF).contains("root." + group) && !configuredQueues.get((Object)FSQueueType.PARENT).contains("root." + group)) continue;
                return "root." + group;
            }
            return "";
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    public static class PrimaryGroup
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) throws IOException {
            List groupList = groups.getGroups(user);
            if (groupList.isEmpty()) {
                throw new IOException("No groups returned for user " + user);
            }
            return "root." + this.cleanName((String)groupList.get(0));
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }

    public static class User
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Map<FSQueueType, Set<String>> configuredQueues) {
            return "root." + this.cleanName(user);
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }
}

