/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.util.EnumSet;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.oncrpc.XDR;

public class SetAttr3 {
    public static final int TIME_DONT_CHANGE = 0;
    public static final int TIME_SET_TO_SERVER_TIME = 1;
    public static final int TIME_SET_TO_CLIENT_TIME = 2;
    private int mode = 0;
    private int uid = 0;
    private int gid = 0;
    private long size = 0L;
    private NfsTime atime;
    private NfsTime mtime;
    private EnumSet<SetAttrField> updateFields = EnumSet.noneOf(SetAttrField.class);

    public int getMode() {
        return this.mode;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public long getSize() {
        return this.size;
    }

    public NfsTime getAtime() {
        return this.atime;
    }

    public NfsTime getMtime() {
        return this.mtime;
    }

    public EnumSet<SetAttrField> getUpdateFields() {
        return this.updateFields;
    }

    public void setUpdateFields(EnumSet<SetAttrField> updateFields) {
        this.updateFields = updateFields;
    }

    public void serialize(XDR xdr) {
        if (!this.updateFields.contains((Object)SetAttrField.MODE)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            xdr.writeInt(this.mode);
        }
        if (!this.updateFields.contains((Object)SetAttrField.UID)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            xdr.writeInt(this.uid);
        }
        if (!this.updateFields.contains((Object)SetAttrField.GID)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            xdr.writeInt(this.gid);
        }
        if (!this.updateFields.contains((Object)SetAttrField.SIZE)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            xdr.writeLongAsHyper(this.size);
        }
        if (!this.updateFields.contains((Object)SetAttrField.ATIME)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            this.atime.serialize(xdr);
        }
        if (!this.updateFields.contains((Object)SetAttrField.MTIME)) {
            xdr.writeBoolean(false);
        } else {
            xdr.writeBoolean(true);
            this.mtime.serialize(xdr);
        }
    }

    public void deserialize(XDR xdr) {
        int timeSetHow;
        if (xdr.readBoolean()) {
            this.mode = xdr.readInt();
            this.updateFields.add(SetAttrField.MODE);
        }
        if (xdr.readBoolean()) {
            this.uid = xdr.readInt();
            this.updateFields.add(SetAttrField.UID);
        }
        if (xdr.readBoolean()) {
            this.gid = xdr.readInt();
            this.updateFields.add(SetAttrField.GID);
        }
        if (xdr.readBoolean()) {
            this.size = xdr.readHyper();
            this.updateFields.add(SetAttrField.SIZE);
        }
        if ((timeSetHow = xdr.readInt()) == 2) {
            this.atime = NfsTime.deserialize(xdr);
            this.updateFields.add(SetAttrField.ATIME);
        } else if (timeSetHow == 1) {
            this.atime = new NfsTime(System.currentTimeMillis());
            this.updateFields.add(SetAttrField.ATIME);
        }
        timeSetHow = xdr.readInt();
        if (timeSetHow == 2) {
            this.mtime = NfsTime.deserialize(xdr);
            this.updateFields.add(SetAttrField.MTIME);
        } else if (timeSetHow == 1) {
            this.mtime = new NfsTime(System.currentTimeMillis());
            this.updateFields.add(SetAttrField.MTIME);
        }
    }

    public static enum SetAttrField {
        MODE,
        UID,
        GID,
        SIZE,
        ATIME,
        MTIME;

    }
}

