/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.util.FSDownload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalDistributedCacheManager {
    public static final Logger LOG = LoggerFactory.getLogger(LocalDistributedCacheManager.class);
    private List<String> localArchives = new ArrayList<String>();
    private List<String> localFiles = new ArrayList<String>();
    private List<String> localClasspaths = new ArrayList<String>();
    private List<File> symlinksCreated = new ArrayList<File>();
    private boolean setupCalled = false;

    LocalDistributedCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(JobConf conf) throws IOException {
        Path[] fileClassPaths;
        File workDir = new File(System.getProperty("user.dir"));
        LinkedHashMap<String, LocalResource> localResources = new LinkedHashMap<String, LocalResource>();
        MRApps.setupDistributedCache((Configuration)conf, localResources);
        AtomicLong uniqueNumberGenerator = new AtomicLong(System.currentTimeMillis());
        HashMap<String, Path> classpaths = new HashMap<String, Path>();
        Path[] archiveClassPaths = DistributedCache.getArchiveClassPaths((Configuration)conf);
        if (archiveClassPaths != null) {
            for (Path p : archiveClassPaths) {
                classpaths.put(p.toUri().getPath().toString(), p);
            }
        }
        if ((fileClassPaths = DistributedCache.getFileClassPaths((Configuration)conf)) != null) {
            for (Path p : fileClassPaths) {
                classpaths.put(p.toUri().getPath().toString(), p);
            }
        }
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("mapreduce.cluster.local.dir");
        FileContext localFSFileContext = FileContext.getLocalFSFileContext();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ExecutorService exec = null;
        try {
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("LocalDistributedCacheManager Downloader #%d").build();
            exec = HadoopExecutors.newCachedThreadPool((ThreadFactory)tf);
            Path destPath = localDirAllocator.getLocalPathForWrite(".", (Configuration)conf);
            HashMap resourcesToPaths = Maps.newHashMap();
            for (LocalResource localResource : localResources.values()) {
                FSDownload download = new FSDownload(localFSFileContext, ugi, (Configuration)conf, new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet())), localResource);
                Future future = exec.submit(download);
                resourcesToPaths.put(localResource, future);
            }
            for (Map.Entry entry : localResources.entrySet()) {
                Path resourcePath;
                Path path;
                LocalResource resource = (LocalResource)entry.getValue();
                try {
                    path = (Path)((Future)resourcesToPaths.get(resource)).get();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
                String pathString = path.toUri().toString();
                String link = (String)entry.getKey();
                String target = new File(path.toUri()).getPath();
                this.symlink(workDir, target, link);
                if (resource.getType() == LocalResourceType.ARCHIVE) {
                    this.localArchives.add(pathString);
                } else if (resource.getType() == LocalResourceType.FILE) {
                    this.localFiles.add(pathString);
                } else if (resource.getType() == LocalResourceType.PATTERN) {
                    throw new IllegalArgumentException("Resource type PATTERN is not implemented yet. " + resource.getResource());
                }
                try {
                    resourcePath = resource.getResource().toPath();
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                LOG.info(String.format("Localized %s as %s", resourcePath, path));
                String cp = resourcePath.toUri().getPath();
                if (!classpaths.keySet().contains(cp)) continue;
                this.localClasspaths.add(path.toUri().getPath().toString());
            }
        }
        finally {
            if (exec != null) {
                exec.shutdown();
            }
        }
        if (!this.localArchives.isEmpty()) {
            conf.set("mapreduce.job.cache.local.archives", StringUtils.arrayToString((String[])this.localArchives.toArray(new String[this.localArchives.size()])));
        }
        if (!this.localFiles.isEmpty()) {
            conf.set("mapreduce.job.cache.local.files", StringUtils.arrayToString((String[])this.localFiles.toArray(new String[this.localArchives.size()])));
        }
        this.setupCalled = true;
    }

    private void symlink(File workDir, String target, String link) throws IOException {
        File flink;
        if (link != null && !(flink = new File(link = workDir.toString() + "/" + link)).exists()) {
            LOG.info(String.format("Creating symlink: %s <- %s", target, link));
            if (0 != FileUtil.symLink((String)target, (String)link)) {
                LOG.warn(String.format("Failed to create symlink: %s <- %s", target, link));
            } else {
                this.symlinksCreated.add(new File(link));
            }
        }
    }

    public boolean hasLocalClasspaths() {
        if (!this.setupCalled) {
            throw new IllegalStateException("hasLocalClasspaths() should be called after setup()");
        }
        return !this.localClasspaths.isEmpty();
    }

    public ClassLoader makeClassLoader(final ClassLoader parent) throws MalformedURLException {
        final URL[] urls = new URL[this.localClasspaths.size()];
        for (int i = 0; i < this.localClasspaths.size(); ++i) {
            urls[i] = new File(this.localClasspaths.get(i)).toURI().toURL();
            LOG.info(urls[i].toString());
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    public void close() throws IOException {
        for (File symlink : this.symlinksCreated) {
            if (symlink.delete()) continue;
            LOG.warn("Failed to delete symlink created by the local job runner: " + symlink);
        }
        FileContext localFSFileContext = FileContext.getLocalFSFileContext();
        for (String archive : this.localArchives) {
            localFSFileContext.delete(new Path(archive), true);
        }
        for (String file : this.localFiles) {
            localFSFileContext.delete(new Path(file), true);
        }
    }
}

