/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.CounterGroup;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class TypeConverter {
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final String TT_NAME_PREFIX = "tracker_";

    public static JobID fromYarn(JobId id) {
        String identifier = TypeConverter.fromClusterTimeStamp(id.getAppId().getClusterTimestamp());
        return new JobID(identifier, id.getId());
    }

    public static org.apache.hadoop.mapreduce.JobID fromYarn(ApplicationId appID) {
        String identifier = TypeConverter.fromClusterTimeStamp(appID.getClusterTimestamp());
        return new JobID(identifier, appID.getId());
    }

    public static JobId toYarn(org.apache.hadoop.mapreduce.JobID id) {
        JobId jobId = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobId.setId(id.getId());
        ApplicationId appId = (ApplicationId)recordFactory.newRecordInstance(ApplicationId.class);
        appId.setId(id.getId());
        appId.setClusterTimestamp(TypeConverter.toClusterTimeStamp(id.getJtIdentifier()));
        jobId.setAppId(appId);
        return jobId;
    }

    private static String fromClusterTimeStamp(long clusterTimeStamp) {
        return Long.toString(clusterTimeStamp);
    }

    private static long toClusterTimeStamp(String identifier) {
        return Long.parseLong(identifier);
    }

    public static TaskType fromYarn(org.apache.hadoop.mapreduce.v2.api.records.TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return TaskType.MAP;
            }
            case REDUCE: {
                return TaskType.REDUCE;
            }
        }
        throw new YarnException("Unrecognized task type: " + (Object)((Object)taskType));
    }

    public static org.apache.hadoop.mapreduce.v2.api.records.TaskType toYarn(TaskType taskType) {
        switch (taskType) {
            case MAP: {
                return org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP;
            }
            case REDUCE: {
                return org.apache.hadoop.mapreduce.v2.api.records.TaskType.REDUCE;
            }
        }
        throw new YarnException("Unrecognized task type: " + taskType);
    }

    public static TaskID fromYarn(TaskId id) {
        return new TaskID((org.apache.hadoop.mapreduce.JobID)TypeConverter.fromYarn(id.getJobId()), TypeConverter.fromYarn(id.getTaskType()), id.getId());
    }

    public static TaskId toYarn(org.apache.hadoop.mapreduce.TaskID id) {
        TaskId taskId = (TaskId)recordFactory.newRecordInstance(TaskId.class);
        taskId.setId(id.getId());
        taskId.setTaskType(TypeConverter.toYarn(id.getTaskType()));
        taskId.setJobId(TypeConverter.toYarn(id.getJobID()));
        return taskId;
    }

    public static TaskAttemptState toYarn(TaskStatus.State state) {
        switch (state) {
            case COMMIT_PENDING: {
                return TaskAttemptState.COMMIT_PENDING;
            }
            case FAILED: 
            case FAILED_UNCLEAN: {
                return TaskAttemptState.FAILED;
            }
            case KILLED: 
            case KILLED_UNCLEAN: {
                return TaskAttemptState.KILLED;
            }
            case RUNNING: {
                return TaskAttemptState.RUNNING;
            }
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
            case UNASSIGNED: {
                return TaskAttemptState.STARTING;
            }
        }
        throw new YarnException("Unrecognized State: " + state);
    }

    public static Phase toYarn(TaskStatus.Phase phase) {
        switch (phase) {
            case STARTING: {
                return Phase.STARTING;
            }
            case MAP: {
                return Phase.MAP;
            }
            case SHUFFLE: {
                return Phase.SHUFFLE;
            }
            case SORT: {
                return Phase.SORT;
            }
            case REDUCE: {
                return Phase.REDUCE;
            }
            case CLEANUP: {
                return Phase.CLEANUP;
            }
        }
        throw new YarnException("Unrecognized Phase: " + phase);
    }

    public static TaskCompletionEvent[] fromYarn(TaskAttemptCompletionEvent[] newEvents) {
        TaskCompletionEvent[] oldEvents = new TaskCompletionEvent[newEvents.length];
        int i = 0;
        for (TaskAttemptCompletionEvent newEvent : newEvents) {
            oldEvents[i++] = TypeConverter.fromYarn(newEvent);
        }
        return oldEvents;
    }

    public static TaskCompletionEvent fromYarn(TaskAttemptCompletionEvent newEvent) {
        return new TaskCompletionEvent(newEvent.getEventId(), TypeConverter.fromYarn(newEvent.getAttemptId()), newEvent.getAttemptId().getId(), newEvent.getAttemptId().getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP), TypeConverter.fromYarn(newEvent.getStatus()), newEvent.getMapOutputServerAddress());
    }

    public static TaskCompletionEvent.Status fromYarn(TaskAttemptCompletionEventStatus newStatus) {
        switch (newStatus) {
            case FAILED: {
                return TaskCompletionEvent.Status.FAILED;
            }
            case KILLED: {
                return TaskCompletionEvent.Status.KILLED;
            }
            case OBSOLETE: {
                return TaskCompletionEvent.Status.OBSOLETE;
            }
            case SUCCEEDED: {
                return TaskCompletionEvent.Status.SUCCEEDED;
            }
            case TIPFAILED: {
                return TaskCompletionEvent.Status.TIPFAILED;
            }
        }
        throw new YarnException("Unrecognized status: " + (Object)((Object)newStatus));
    }

    public static TaskAttemptID fromYarn(TaskAttemptId id) {
        return new TaskAttemptID(TypeConverter.fromYarn(id.getTaskId()), id.getId());
    }

    public static TaskAttemptId toYarn(TaskAttemptID id) {
        TaskAttemptId taskAttemptId = (TaskAttemptId)recordFactory.newRecordInstance(TaskAttemptId.class);
        taskAttemptId.setTaskId(TypeConverter.toYarn((org.apache.hadoop.mapreduce.TaskID)id.getTaskID()));
        taskAttemptId.setId(id.getId());
        return taskAttemptId;
    }

    public static TaskAttemptId toYarn(org.apache.hadoop.mapreduce.TaskAttemptID id) {
        TaskAttemptId taskAttemptId = (TaskAttemptId)recordFactory.newRecordInstance(TaskAttemptId.class);
        taskAttemptId.setTaskId(TypeConverter.toYarn(id.getTaskID()));
        taskAttemptId.setId(id.getId());
        return taskAttemptId;
    }

    public static Counters fromYarn(org.apache.hadoop.mapreduce.v2.api.records.Counters yCntrs) {
        if (yCntrs == null) {
            return null;
        }
        Counters counters = new Counters();
        for (CounterGroup yGrp : yCntrs.getAllCounterGroups().values()) {
            counters.addGroup(yGrp.getName(), yGrp.getDisplayName());
            for (org.apache.hadoop.mapreduce.v2.api.records.Counter yCntr : yGrp.getAllCounters().values()) {
                Counter c = counters.findCounter(yGrp.getName(), yCntr.getName());
                c.setValue(yCntr.getValue());
            }
        }
        return counters;
    }

    public static org.apache.hadoop.mapreduce.v2.api.records.Counters toYarn(org.apache.hadoop.mapred.Counters counters) {
        if (counters == null) {
            return null;
        }
        org.apache.hadoop.mapreduce.v2.api.records.Counters yCntrs = (org.apache.hadoop.mapreduce.v2.api.records.Counters)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counters.class);
        yCntrs.addAllCounterGroups(new HashMap<String, CounterGroup>());
        for (Counters.Group grp : counters) {
            CounterGroup yGrp = (CounterGroup)recordFactory.newRecordInstance(CounterGroup.class);
            yGrp.setName(grp.getName());
            yGrp.setDisplayName(grp.getDisplayName());
            yGrp.addAllCounters(new HashMap<String, org.apache.hadoop.mapreduce.v2.api.records.Counter>());
            for (Counters.Counter cntr : grp) {
                org.apache.hadoop.mapreduce.v2.api.records.Counter yCntr = (org.apache.hadoop.mapreduce.v2.api.records.Counter)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counter.class);
                yCntr.setName(cntr.getName());
                yCntr.setDisplayName(cntr.getDisplayName());
                yCntr.setValue(cntr.getValue());
                yGrp.setCounter(yCntr.getName(), yCntr);
            }
            yCntrs.setCounterGroup(yGrp.getName(), yGrp);
        }
        return yCntrs;
    }

    public static org.apache.hadoop.mapreduce.v2.api.records.Counters toYarn(Counters counters) {
        if (counters == null) {
            return null;
        }
        org.apache.hadoop.mapreduce.v2.api.records.Counters yCntrs = (org.apache.hadoop.mapreduce.v2.api.records.Counters)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counters.class);
        yCntrs.addAllCounterGroups(new HashMap<String, CounterGroup>());
        for (org.apache.hadoop.mapreduce.CounterGroup grp : counters) {
            CounterGroup yGrp = (CounterGroup)recordFactory.newRecordInstance(CounterGroup.class);
            yGrp.setName(grp.getName());
            yGrp.setDisplayName(grp.getDisplayName());
            yGrp.addAllCounters(new HashMap<String, org.apache.hadoop.mapreduce.v2.api.records.Counter>());
            for (Counter cntr : grp) {
                org.apache.hadoop.mapreduce.v2.api.records.Counter yCntr = (org.apache.hadoop.mapreduce.v2.api.records.Counter)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counter.class);
                yCntr.setName(cntr.getName());
                yCntr.setDisplayName(cntr.getDisplayName());
                yCntr.setValue(cntr.getValue());
                yGrp.setCounter(yCntr.getName(), yCntr);
            }
            yCntrs.setCounterGroup(yGrp.getName(), yGrp);
        }
        return yCntrs;
    }

    public static JobStatus fromYarn(JobReport jobreport, String trackingUrl) {
        JobPriority jobPriority = JobPriority.NORMAL;
        org.apache.hadoop.mapred.JobStatus jobStatus = new org.apache.hadoop.mapred.JobStatus(TypeConverter.fromYarn(jobreport.getJobId()), jobreport.getSetupProgress(), jobreport.getMapProgress(), jobreport.getReduceProgress(), jobreport.getCleanupProgress(), TypeConverter.fromYarn(jobreport.getJobState()), jobPriority, jobreport.getUser(), jobreport.getJobName(), jobreport.getJobFile(), trackingUrl, jobreport.isUber());
        jobStatus.setFailureInfo(jobreport.getDiagnostics());
        return jobStatus;
    }

    public static QueueState fromYarn(org.apache.hadoop.yarn.api.records.QueueState state) {
        QueueState qState = QueueState.getState((String)state.toString().toLowerCase());
        return qState;
    }

    public static int fromYarn(JobState state) {
        switch (state) {
            case NEW: 
            case INITED: {
                return org.apache.hadoop.mapred.JobStatus.PREP;
            }
            case RUNNING: {
                return org.apache.hadoop.mapred.JobStatus.RUNNING;
            }
            case KILLED: {
                return org.apache.hadoop.mapred.JobStatus.KILLED;
            }
            case SUCCEEDED: {
                return org.apache.hadoop.mapred.JobStatus.SUCCEEDED;
            }
            case FAILED: 
            case ERROR: {
                return org.apache.hadoop.mapred.JobStatus.FAILED;
            }
        }
        throw new YarnException("Unrecognized job state: " + (Object)((Object)state));
    }

    public static TIPStatus fromYarn(TaskState state) {
        switch (state) {
            case NEW: 
            case SCHEDULED: {
                return TIPStatus.PENDING;
            }
            case RUNNING: {
                return TIPStatus.RUNNING;
            }
            case KILLED: {
                return TIPStatus.KILLED;
            }
            case SUCCEEDED: {
                return TIPStatus.COMPLETE;
            }
            case FAILED: {
                return TIPStatus.FAILED;
            }
        }
        throw new YarnException("Unrecognized task state: " + (Object)((Object)state));
    }

    public static org.apache.hadoop.mapreduce.TaskReport fromYarn(TaskReport report) {
        String[] diagnostics = null;
        if (report.getDiagnosticsList() != null) {
            diagnostics = new String[report.getDiagnosticsCount()];
            int i = 0;
            for (String cs : report.getDiagnosticsList()) {
                diagnostics[i++] = cs.toString();
            }
        } else {
            diagnostics = new String[]{};
        }
        org.apache.hadoop.mapreduce.TaskReport rep = new org.apache.hadoop.mapreduce.TaskReport((org.apache.hadoop.mapreduce.TaskID)TypeConverter.fromYarn(report.getTaskId()), report.getProgress(), report.getTaskState().toString(), diagnostics, TypeConverter.fromYarn(report.getTaskState()), report.getStartTime(), report.getFinishTime(), TypeConverter.fromYarn(report.getCounters()));
        ArrayList<TaskAttemptID> runningAtts = new ArrayList<TaskAttemptID>();
        for (TaskAttemptId id : report.getRunningAttemptsList()) {
            runningAtts.add(TypeConverter.fromYarn(id));
        }
        rep.setRunningTaskAttemptIds(runningAtts);
        if (report.getSuccessfulAttempt() != null) {
            rep.setSuccessfulAttemptId((org.apache.hadoop.mapreduce.TaskAttemptID)TypeConverter.fromYarn(report.getSuccessfulAttempt()));
        }
        return rep;
    }

    public static List<org.apache.hadoop.mapreduce.TaskReport> fromYarn(List<TaskReport> taskReports) {
        ArrayList<org.apache.hadoop.mapreduce.TaskReport> reports = new ArrayList<org.apache.hadoop.mapreduce.TaskReport>();
        for (TaskReport r : taskReports) {
            reports.add(TypeConverter.fromYarn(r));
        }
        return reports;
    }

    public static JobStatus.State fromYarn(YarnApplicationState yarnApplicationState, FinalApplicationStatus finalApplicationStatus) {
        switch (yarnApplicationState) {
            case NEW: 
            case SUBMITTED: {
                return JobStatus.State.PREP;
            }
            case RUNNING: {
                return JobStatus.State.RUNNING;
            }
            case FINISHED: {
                if (finalApplicationStatus == FinalApplicationStatus.SUCCEEDED) {
                    return JobStatus.State.SUCCEEDED;
                }
                if (finalApplicationStatus == FinalApplicationStatus.KILLED) {
                    return JobStatus.State.KILLED;
                }
            }
            case FAILED: {
                return JobStatus.State.FAILED;
            }
            case KILLED: {
                return JobStatus.State.KILLED;
            }
        }
        throw new YarnException("Unrecognized application state: " + yarnApplicationState);
    }

    public static TaskTrackerInfo fromYarn(NodeReport node) {
        TaskTrackerInfo taskTracker = new TaskTrackerInfo(TT_NAME_PREFIX + node.getNodeId().toString());
        return taskTracker;
    }

    public static TaskTrackerInfo[] fromYarnNodes(List<NodeReport> nodes) {
        ArrayList<TaskTrackerInfo> taskTrackers = new ArrayList<TaskTrackerInfo>();
        for (NodeReport node : nodes) {
            taskTrackers.add(TypeConverter.fromYarn(node));
        }
        return taskTrackers.toArray(new TaskTrackerInfo[nodes.size()]);
    }

    public static JobStatus fromYarn(ApplicationReport application, String jobFile) {
        String trackingUrl = application.getTrackingUrl();
        trackingUrl = trackingUrl == null ? "" : trackingUrl;
        JobStatus jobStatus = new JobStatus(TypeConverter.fromYarn(application.getApplicationId()), 0.0f, 0.0f, 0.0f, 0.0f, TypeConverter.fromYarn(application.getYarnApplicationState(), application.getFinalApplicationStatus()), org.apache.hadoop.mapreduce.JobPriority.NORMAL, application.getUser(), application.getName(), application.getQueue(), jobFile, trackingUrl, false);
        jobStatus.setSchedulingInfo(trackingUrl);
        jobStatus.setStartTime(application.getStartTime());
        jobStatus.setFailureInfo(application.getDiagnostics());
        jobStatus.setNeededMem(application.getApplicationResourceUsageReport().getNeededResources().getMemory());
        jobStatus.setNumReservedSlots(application.getApplicationResourceUsageReport().getNumReservedContainers());
        jobStatus.setNumUsedSlots(application.getApplicationResourceUsageReport().getNumUsedContainers());
        jobStatus.setReservedMem(application.getApplicationResourceUsageReport().getReservedResources().getMemory());
        jobStatus.setUsedMem(application.getApplicationResourceUsageReport().getUsedResources().getMemory());
        return jobStatus;
    }

    public static JobStatus[] fromYarnApps(List<ApplicationReport> applications, Configuration conf) {
        ArrayList<JobStatus> jobStatuses = new ArrayList<JobStatus>();
        for (ApplicationReport application : applications) {
            org.apache.hadoop.mapreduce.JobID jobId = TypeConverter.fromYarn(application.getApplicationId());
            jobStatuses.add(TypeConverter.fromYarn(application, MRApps.getJobFile(conf, application.getUser(), jobId)));
        }
        return jobStatuses.toArray(new JobStatus[jobStatuses.size()]);
    }

    public static QueueInfo fromYarn(org.apache.hadoop.yarn.api.records.QueueInfo queueInfo, Configuration conf) {
        QueueInfo toReturn = new QueueInfo(queueInfo.getQueueName(), "Capacity: " + queueInfo.getCapacity() * 100.0f + ", MaximumCapacity: " + (queueInfo.getMaximumCapacity() < 0.0f ? "UNDEFINED" : Float.valueOf(queueInfo.getMaximumCapacity())) + ", CurrentCapacity: " + queueInfo.getCurrentCapacity() * 100.0f, TypeConverter.fromYarn(queueInfo.getQueueState()), TypeConverter.fromYarnApps(queueInfo.getApplications(), conf));
        ArrayList<QueueInfo> childQueues = new ArrayList<QueueInfo>();
        for (org.apache.hadoop.yarn.api.records.QueueInfo childQueue : queueInfo.getChildQueues()) {
            childQueues.add(TypeConverter.fromYarn(childQueue, conf));
        }
        toReturn.setQueueChildren(childQueues);
        return toReturn;
    }

    public static QueueInfo[] fromYarnQueueInfo(List<org.apache.hadoop.yarn.api.records.QueueInfo> queues, Configuration conf) {
        ArrayList<QueueInfo> queueInfos = new ArrayList<QueueInfo>(queues.size());
        for (org.apache.hadoop.yarn.api.records.QueueInfo queue : queues) {
            queueInfos.add(TypeConverter.fromYarn(queue, conf));
        }
        return queueInfos.toArray(new QueueInfo[queueInfos.size()]);
    }

    public static QueueAclsInfo[] fromYarnQueueUserAclsInfo(List<QueueUserACLInfo> userAcls) {
        ArrayList<QueueAclsInfo> acls = new ArrayList<QueueAclsInfo>();
        for (QueueUserACLInfo aclInfo : userAcls) {
            ArrayList<String> operations = new ArrayList<String>();
            for (QueueACL qAcl : aclInfo.getUserAcls()) {
                operations.add(qAcl.toString());
            }
            QueueAclsInfo acl = new QueueAclsInfo(aclInfo.getQueueName(), operations.toArray(new String[operations.size()]));
            acls.add(acl);
        }
        return acls.toArray(new QueueAclsInfo[acls.size()]);
    }
}

