/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.mortbay.util.ajax.JSON;

public class MiniDFSClusterManager {
    private static final Log LOG = LogFactory.getLog(MiniDFSClusterManager.class);
    private MiniDFSCluster dfs;
    private String writeDetails;
    private int numDataNodes;
    private int nameNodePort;
    private HdfsServerConstants.StartupOption dfsOpts;
    private String writeConfig;
    private Configuration conf;
    private boolean format;
    private static final long SLEEP_INTERVAL_MS = 60000L;

    private Options makeOptions() {
        Options options = new Options();
        Options options2 = options.addOption("datanodes", true, "How many datanodes to start (default 1)").addOption("format", false, "Format the DFS (default false)").addOption("cmdport", true, "Which port to listen on for commands (default 0--we choose)").addOption("nnport", true, "NameNode port (default 0--we choose)").addOption("namenode", true, "URL of the namenode (default is either the DFS cluster or a temporary dir)");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Options to pass into configuration object");
        Options options3 = options2.addOption(OptionBuilder.create((String)"D"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Save configuration to this XML file.");
        Options options4 = options3.addOption(OptionBuilder.create((String)"writeConfig"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Write basic information to this JSON file.");
        Options options5 = options4.addOption(OptionBuilder.create((String)"writeDetails"));
        OptionBuilder.withDescription((String)"Prints option help.");
        options5.addOption(OptionBuilder.create((String)"help"));
        return options;
    }

    public void run(String[] args) throws IOException {
        if (!this.parseArguments(args)) {
            return;
        }
        this.start();
        this.sleepForever();
    }

    private void sleepForever() {
        while (true) {
            try {
                do {
                    Thread.sleep(60000L);
                } while (this.dfs.isClusterUp());
                LOG.info((Object)"Cluster is no longer up, exiting");
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() throws IOException, FileNotFoundException {
        this.dfs = new MiniDFSCluster.Builder(this.conf).nameNodePort(this.nameNodePort).numDataNodes(this.numDataNodes).startupOption(this.dfsOpts).format(this.format).build();
        this.dfs.waitActive();
        LOG.info((Object)("Started MiniDFSCluster -- namenode on port " + this.dfs.getNameNodePort()));
        if (this.writeConfig != null) {
            FileOutputStream fos = new FileOutputStream(new File(this.writeConfig));
            this.conf.writeXml((OutputStream)fos);
            fos.close();
        }
        if (this.writeDetails != null) {
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            if (this.dfs != null) {
                map.put("namenode_port", this.dfs.getNameNodePort());
            }
            FileWriter fw = new FileWriter(new File(this.writeDetails));
            fw.write(new JSON().toJSON(map));
            fw.close();
        }
    }

    private boolean parseArguments(String[] args) {
        String[] arr$;
        int len$;
        int i$;
        CommandLine cli;
        Options options = this.makeOptions();
        try {
            GnuParser parser = new GnuParser();
            cli = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed:  " + e.getMessage()));
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.hasOption("help")) {
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        if (cli.getArgs().length > 0 && (i$ = 0) < (len$ = (arr$ = cli.getArgs()).length)) {
            String arg = arr$[i$];
            LOG.error((Object)("Unrecognized option: " + arg));
            new HelpFormatter().printHelp("...", options);
            return false;
        }
        this.numDataNodes = this.intArgument(cli, "datanodes", 1);
        this.nameNodePort = this.intArgument(cli, "nnport", 0);
        if (cli.hasOption("format")) {
            this.dfsOpts = HdfsServerConstants.StartupOption.FORMAT;
            this.format = true;
        } else {
            this.dfsOpts = HdfsServerConstants.StartupOption.REGULAR;
            this.format = false;
        }
        this.writeDetails = cli.getOptionValue("writeDetails");
        this.writeConfig = cli.getOptionValue("writeConfig");
        this.conf = new HdfsConfiguration();
        this.updateConfiguration(this.conf, cli.getOptionValues("D"));
        return true;
    }

    private void updateConfiguration(Configuration conf2, String[] keyvalues) {
        int num_confs_updated = 0;
        if (keyvalues != null) {
            for (String prop : keyvalues) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length == 2) {
                    conf2.set(keyval[0], keyval[1]);
                    ++num_confs_updated;
                    continue;
                }
                LOG.warn((Object)("Ignoring -D option " + prop));
            }
        }
        LOG.info((Object)("Updated " + num_confs_updated + " configuration settings from command line."));
    }

    private int intArgument(CommandLine cli, String argName, int defaultValue) {
        String o = cli.getOptionValue(argName);
        try {
            if (o != null) {
                return Integer.parseInt(o);
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)("Couldn't parse value (" + o + ") for option " + argName + ". Using default: " + defaultValue));
        }
        return defaultValue;
    }

    public static void main(String[] args) throws IOException {
        new MiniDFSClusterManager().run(args);
    }
}

