/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hdfs.util.ExactSizeInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestExactSizeInputStream {
    @Test
    public void testBasicsReadSingle() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("hello"), 3);
        Assert.assertEquals((long)3L, (long)s.available());
        Assert.assertEquals((long)104L, (long)s.read());
        Assert.assertEquals((long)101L, (long)s.read());
        Assert.assertEquals((long)108L, (long)s.read());
        Assert.assertEquals((long)-1L, (long)s.read());
        Assert.assertEquals((long)0L, (long)s.available());
    }

    @Test
    public void testBasicsReadArray() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("hello"), 3);
        Assert.assertEquals((long)3L, (long)s.available());
        byte[] buf = new byte[10];
        Assert.assertEquals((long)2L, (long)s.read(buf, 0, 2));
        Assert.assertEquals((long)104L, (long)buf[0]);
        Assert.assertEquals((long)101L, (long)buf[1]);
        Assert.assertEquals((long)1L, (long)s.read(buf, 0, 2));
        Assert.assertEquals((long)108L, (long)buf[0]);
        Assert.assertEquals((long)-1L, (long)s.read(buf, 0, 2));
    }

    @Test
    public void testBasicsSkip() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("hello"), 3);
        Assert.assertEquals((long)3L, (long)s.available());
        Assert.assertEquals((long)2L, (long)s.skip(2L));
        Assert.assertEquals((long)1L, (long)s.skip(2L));
        Assert.assertEquals((long)0L, (long)s.skip(2L));
    }

    @Test
    public void testReadNotEnough() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("he"), 5);
        Assert.assertEquals((long)2L, (long)s.available());
        Assert.assertEquals((long)104L, (long)s.read());
        Assert.assertEquals((long)101L, (long)s.read());
        try {
            s.read();
            Assert.fail((String)"Read when should be out of data");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testSkipNotEnough() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("he"), 5);
        Assert.assertEquals((long)2L, (long)s.skip(3L));
        try {
            s.skip(1L);
            Assert.fail((String)"Skip when should be out of data");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testReadArrayNotEnough() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("he"), 5);
        byte[] buf = new byte[10];
        Assert.assertEquals((long)2L, (long)s.read(buf, 0, 5));
        try {
            s.read(buf, 2, 3);
            Assert.fail((String)"Read buf when should be out of data");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testMark() throws IOException {
        ExactSizeInputStream s = new ExactSizeInputStream(TestExactSizeInputStream.byteStream("he"), 5);
        Assert.assertFalse((boolean)s.markSupported());
        try {
            s.mark(1);
            Assert.fail((String)"Mark should not succeed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static InputStream byteStream(String data) {
        return new ByteArrayInputStream(data.getBytes());
    }
}

