/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestStoragePolicyCommands {
    private static final short REPL = 1;
    private static final int SIZE = 128;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    @Before
    public void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @After
    public void clusterShutdown() throws IOException {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testSetAndGetStoragePolicy() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)fs, bar, 128L, (short)1, 0L);
        DFSTestUtil.DFSAdminRun("-getStoragePolicy /foo", 0, "The storage policy of " + foo.toString() + " is unspecified", conf);
        DFSTestUtil.DFSAdminRun("-getStoragePolicy /foo/bar", 0, "The storage policy of " + bar.toString() + " is unspecified", conf);
        DFSTestUtil.DFSAdminRun("-setStoragePolicy /foo WARM", 0, "Set storage policy WARM on " + foo.toString(), conf);
        DFSTestUtil.DFSAdminRun("-setStoragePolicy /foo/bar COLD", 0, "Set storage policy COLD on " + bar.toString(), conf);
        DFSTestUtil.DFSAdminRun("-setStoragePolicy /fooz WARM", -1, "File/Directory does not exist: /fooz", conf);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        DFSTestUtil.DFSAdminRun("-getStoragePolicy /foo", 0, "The storage policy of " + foo.toString() + ":\n" + warm, conf);
        DFSTestUtil.DFSAdminRun("-getStoragePolicy /foo/bar", 0, "The storage policy of " + bar.toString() + ":\n" + cold, conf);
        DFSTestUtil.DFSAdminRun("-getStoragePolicy /fooz", -1, "File/Directory does not exist: /fooz", conf);
    }
}

